#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Witness
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241015.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-witness'
GAME_NAME='The Witness'

ARCHIVE_BASE_0_NAME='setup_the_witness_21-12-2017_(19091).exe'
ARCHIVE_BASE_0_MD5='5bfb0d687fb80cdd64cdee7b6b567400'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_witness_21-12-2017_(19091)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='90a24fed5d8e2e52ab1bf2de84349984'
ARCHIVE_BASE_0_SIZE='4300000'
ARCHIVE_BASE_0_VERSION='2017.12.21-gog19091'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_witness'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN64_FILES='
amd_ags_x64.dll
anselsdk64.dll
bink2w64.dll
openvr_api.dll
witness64_d3d11.exe'
CONTENT_GAME_BIN32_FILES='
amd_ags_x86.dll
anselsdk32.dll
bink2w32.dll
witness_d3d11.exe'
## TODO: Check it the Steam libraries can be dropped
CONTENT_GAME_BIN64_FILES="$CONTENT_GAME_BIN64_FILES
steam_api64.dll"
CONTENT_GAME_BIN32_FILES="$CONTENT_GAME_BIN32_FILES
steam_api.dll"
CONTENT_GAME_DATA_FILES='
data
data-pc
controller.vdf
data-pc.zip'
CONTENT_GAME0_DATA_PATH="${CONTENT_PATH_DEFAULT}/__support/app"
CONTENT_GAME0_DATA_FILES='
language.ini'
CONTENT_DOC_DATA_FILE='
software licenses.txt
steam_enabled.txt'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/The Witness'

USER_PERSISTENT_FILES='
language.ini'

APP_MAIN_EXE_BIN32='witness_d3d11.exe'
APP_MAIN_EXE_BIN64='witness64_d3d11.exe'
APP_MAIN_ICON='witness_d3d11.exe'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
