#ifndef _AVRDUDE_UPDATE_H_
#define _AVRDUDE_UPDATE_H_

#include <string>

/*
typedef enum {
  FMT_AUTO,
  FMT_SREC,
  FMT_IHEX,
  FMT_RBIN,
  FMT_IMM,
  FMT_HEX,
  FMT_DEC,
  FMT_OCT,
  FMT_BIN
} FILEFMT;
*/

namespace avrdude {

enum {
  FMT_AUTO,
  FMT_SREC,
  FMT_IHEX,
  FMT_RBIN,
  FMT_IMM,
  FMT_HEX,
  FMT_DEC,
  FMT_OCT,
  FMT_BIN
};

enum {
  DEVICE_READ,
  DEVICE_WRITE,
  DEVICE_VERIFY
};

class UpdatePrivate;

class Update {
  public:
    Update(int op, const std::string & memtype, int filefmt, const std::string & filename);
    virtual ~Update();
    Update * clone();
    void * getPointer();
  protected:
  private:
    Update(Update & update);
    UpdatePrivate * priv;
};

}

#endif // _AVRDUDE_UPDATE_H_
