{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdTransparency: TSFFloat;
    { Internal wrapper for property @code(Transparency). This wrapper API may change, we advise to access simpler @code(Transparency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransparency: TSFFloat read FFdTransparency;
    { Setting @name to value > 0 makes the object partially-transparent. Setting it to 1.0 makes it even invisible (but still collidable). If you want to render the object using blending (which is usually the case for partially-transparent) it is recommended to specify it explicitly using @link(TAppearanceNode.AlphaMode). }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TUnlitMaterialNode ----------------------------------------------- }

function TUnlitMaterialNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TUnlitMaterialNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TUnlitMaterialNode.ClassX3DType: String;
begin
  Result := 'UnlitMaterial';
end;

procedure TUnlitMaterialNode.CreateNode;
begin
  inherited;

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chVisibleNonGeometry;
   FdTransparency.MustBeNonnegative := true;
  AddField(FFdTransparency);

  DefaultContainerField := 'material';
end;

{$endif read_implementation}
