/***********************************************************************/
/* Open Visualization Data Explorer                                    */
/* (C) Copyright IBM Corp. 1989,1999                                   */
/* ALL RIGHTS RESERVED                                                 */
/* This code licensed under the                                        */
/*    "IBM PUBLIC LICENSE - Open Visualization Data Explorer"          */
/***********************************************************************/


#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#ifndef _DXI_IMAGE_H_
#define _DXI_IMAGE_H_

/* TeX starts here. Do not remove this comment. */

/*
\section{Image fields}

This section describes routines for creating a field object that
represents an image of a particular size, for getting a pointer to the
pixels for the image field, and querying the dimensions of the image
field.

An image field is a field with a regular grid of positions with unit
spacing, and a regular grid of quadrilateral connections.  These
routines simplify the task of creating and accessing such a field.
*/

Field DXMakeImageFormat(int, int, char *);
Field DXMakeImage(int width, int height);
/**
\index{DXMakeImage}
Creates a new field object that represents an image of the specified
size.  Returns the image, or returns null and sets the error code to
indicate an error.
**/

RGBColor *DXGetPixels(Field i);
/**
\index{DXGetPixels}
Returns a pointer to the array of pixels associated with the image
field.  This is a pointer to the global memory array and can therefore
be modified.  Returns the pointer, or returns null and sets the error
code to indicate an error.
**/

Field DXGetImageSize(Field i, int *width, int *height);
Object DXGetImageBounds(Object o, int *x, int *y, int *width, int *height);
/**
\index{DXGetImageSize}\index{DXGetImageBounds}
{\tt DXGetImageSize} returns the width and height of a simple image
field.  {\tt DXGetImageBounds} returns the the origin and dimensions of
a simple or composite image field (such as is generated by the Arrange
module).  Returns the image, or returns null and sets the error code
to indicate an error.
**/

Field DXOutputRGB(Field i, int fd);
/**
\index{DXOutputRGB}
Writes the specified image field to the specified file descriptor as
three bytes (red, green and blue) per pixel.  Returns {\tt i}, or
returns null and sets the error code to indicate an error.
**/

Object DXDisplayFB(Object i, char *name, int x, int y);
/**
\index{OutputFB}
Outputs an image {\tt i} to the frame buffer named by {\tt name} at the
position specified by {\tt x} and {\tt y}.  Returns {\tt i}, or
returns null and sets the error code to indicate an error.
**/

Object DXDisplayX(Object i, char *host, char *window);
/**
\index{DXDisplayX}
Creates an X window on the specified {\tt host} with the title
specified by {\tt window}, and displays the contents of the image
specified by {\tt i} in the window.  Returns {\tt i}, or returns null
and sets the error code to indicate an error.
**/

#endif /* _DXI_IMAGE_H_ */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
