;;; initz-util.el --- Utilities.

;; Copyright (C) 2002 OHASHI Akira <bg66@koka-in.org>

;; Author: OHASHI Akira <bg66@koka-in.org>
;; Keywords: startup, init

;; This file is part of Initz.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;;

;;; Code:

(require 'initz-vars)
(require 'initz-globals)
(eval-when-compile (require 'cl))

(defun initz-add-to-load-list (modules)
  "Add MODULES to `initz-load-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (mapc #'(lambda (module)
	      (add-to-list 'initz-load-list-internal module))
	  modules)))

(defun initz-add-to-ignore-list (modules)
  "Add MODULES to `initz-ignore-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (mapc #'(lambda (module)
	      (add-to-list 'initz-ignore-list-internal module))
	  modules)))

(defun initz-remove-from-load-list (modules)
  "Remove MODULES from `initz-load-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (mapc #'(lambda (module)
	      (setq initz-load-list-internal
		    (delete module initz-load-list-internal)))
	  modules)))

(defun initz-remove-from-ignore-list (modules)
  "Remove MODULES from `initz-ignore-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (mapc #'(lambda (module)
	      (setq initz-ignore-list-internal
		    (delete module initz-ignore-list-internal)))
	  modules)))

(defun initz-set-load-list (modules)
  "Set MODULES to `initz-load-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (setq initz-load-list-internal modules)))

(defun initz-set-ignore-list (modules)
  "Set MODULES to `initz-ignore-list-internal'."
  (let ((modules (if (listp modules) modules (list modules))))
    (setq initz-ignore-list-internal modules)))

(defun initz-add-to-load-path (paths)
  "Add PATHS to `load-path' recursively."
  (let ((paths (if (listp paths) paths (list paths))))
    (mapc #'(lambda (path)
	      (let ((path (expand-file-name path)))
		(when (file-directory-p path)
		  (add-to-list 'load-path path)
		  (initz-add-to-load-path
		   ;; Without `.' and `..'.
		   (directory-files
		    path t "^\\([^.].+\\|\\.[^.].+\\|\\.\\..+\\)$")))))
	  paths)))

(defun initz-features ()
  "Return the Initz features."
  (delq nil
	(mapcar
	 #'(lambda (feature)
	     (let ((initz-feature (initz-get-module-name
				   (concat (symbol-name feature) ".el"))))
	       (unless (string= initz-feature initz-null-string)
		 (intern initz-feature))))
	 features)))

;;; Internal functions.
(defun initz-get-base-name (init-file)
  "Return base name of the INIT-FILE."
  (file-name-sans-extension
   (file-name-nondirectory init-file)))

(defun initz-get-module-name (init-file)
  "Return module name of the INIT-FILE."
  (let ((base-name (initz-get-base-name init-file)))
    (cond
     ((string= base-name initz-prefix) initz-prefix)
     ((string-match (concat
		     (regexp-quote (concat initz-prefix
					   initz-separator-string))
		     "\\(" initz-module-regexp "\\)")
		    base-name)
      (match-string 1 base-name))
     (t initz-null-string))))

(provide 'initz-util)

;;; initz-util.el ends here
