/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "functions.h"

#include <QGraphicsDropShadowEffect>
#include <QGraphicsBlurEffect>
#include <QGraphicsPixmapItem>
#include <QGraphicsScene>
#include <QHeaderView>
#include <QMimeData>
#include <QPainter>
#include <QDir>
#include <QUrl>
#include <QRegExp>
#include <QWindow>
#include <QLibrary>
#include <QProcess>
#include <QMessageBox>
#include <QStyleOption>

QString Functions::Url(QString url, const QString &path)
{
    const QString urlType = getUrlType(url);
    const bool hasBackslash = url.contains('\\');
    if (urlType.isEmpty())
    {
        if (!url.startsWith("/"))
        {
            QString addPth = path.isEmpty() ? QDir::currentPath() : path;
            if (!addPth.endsWith("/"))
                addPth += '/';
            url.prepend(addPth);
        }
        if (hasBackslash && !QFileInfo(url).exists())
            url.replace("\\", "/");
        url.prepend("file://");
    }
    return url;
}

/** ********************
* 获取url类型
* @parm : url
***********************/
QString Functions::getUrlType(const QString &url)
{
    int idx = url.indexOf(':');
    if (idx > -1 && url[0] != '/')
        return url.left(idx);
    return QString();
}

/** ********************
* 时间戳转字符串
* @parm : t 时间
* @parm : decimals 是否有小数
***********************/
QString Functions::timeToStr(const double t, const bool decimals)
{
    if (t <= 0.0)
        return QString("--:--:--");

    const int intT = t;
    const int h = intT / 3600;
    const int m = intT % 3600 / 60;
    const int s = intT % 60;

    QString timStr;
//    if (h > 0)  // 默认先显示小时
        timStr = QString("%1:").arg(h, 2, 10, QChar('0'));
    timStr += QString("%1:%2").arg(m, 2, 10, QChar('0')).arg(s, 2, 10, QChar('0'));
    if (decimals)
        timStr += QString(".%1").arg(qRound((t - floor(t)) * 10.0), 1, 10);

    return timStr;
}

/** ********************
* 获取文件全路径
* @parm : file 文件绝对路径
***********************/
QString Functions::filePath(const QString &file)
{
    return file.left(file.lastIndexOf('/') + 1);
}

/**  ********************
* 获取文件扩展名
* @parm : file 文件绝对路径
***********************/
QString Functions::fileExt(const QString &file)
{
    const int idx = file.lastIndexOf('.');
    if (idx > -1)
        return file.mid(idx+1);
    return QString();
}

bool Functions::isKirinCpu()
{
    QProcess p;
    p.setProgram("lscpu");
    p.start();
    p.waitForReadyRead();
    QByteArray line = "123";
    bool is_kirin_cpu = false;
    while (line.length()) {
        line = p.readLine();
        if (QString(line).startsWith(QObject::tr("Model name")) && QString(line).indexOf("Kirin") >= 0) {
            is_kirin_cpu = true;
        }
    }
    p.waitForFinished();
    return is_kirin_cpu;
}

QString Functions::processComand(const QString &cmd)
{
    FILE *fp = popen(cmd.toStdString().c_str(), "r");
    char buffer[1024] = {0};
    QString result = QString::fromUtf8(fgets(buffer, sizeof(buffer), fp));
    pclose(fp);

    return result.replace("\n", "");
}

bool Functions::isQingsongDevice()
{
    return processComand("lsmod | grep qs | wc -l").toInt() > 0;
}
