#
# This file is part of Config-Model-Itself
#
# This software is Copyright (c) 2007-2019 by Dominique Dumont.
#
# This is free software, licensed under:
#
#   The GNU Lesser General Public License, Version 2.1, February 1999
#
#    Copyright (c) 2007-2015 Dominique Dumont.
#
#    This file is part of Config-Model-Itself.
#
#    Config-Model-Itself is free software; you can redistribute it
#    and/or modify it under the terms of the GNU Lesser Public License
#    as published by the Free Software Foundation; either version 2.1
#    of the License, or (at your option) any later version.
#
#    Config-Model-Itself is distributed in the hope that it will be
#    useful, but WITHOUT ANY WARRANTY; without even the implied
#    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#    See the GNU Lesser Public License for more details.
#
#    You should have received a copy of the GNU Lesser Public License
#    along with Config-Model-Itself; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA

use strict;
use warnings;

return [
  {
    'author' => [
      'Dominique Dumont'
    ],
    'class_description' => 'Configuration class. This class represents a node of a configuration tree.',
    'copyright' => [
      '2007-2011 Dominique Dumont.'
    ],
    'element' => [
      'class_description',
      {
        'description' => 'Explain the purpose of this configuration class. This description is re-used to generate the documentation of your configuration class. You can use pod markup to format your description. See L<perlpod> for details.',
        'type' => 'leaf',
        'value_type' => 'string'
      },
      'license',
      {
        'type' => 'leaf',
        'value_type' => 'string'
      },
      'gist',
      {
        'description' => 'String used to construct a summary of the content of a node. This parameter is used by user interface to show users the gist of the content of this node. This parameter has no other effect. This string may contain element values in the form "C<{foo} or {bar}>". When constructing the gist, C<{foo}> is replaced by the value of element C<foo>. Likewise for C<{bar}>.',
        'type' => 'leaf',
        'value_type' => 'string'
      },
      'author',
      {
        'cargo' => {
          'type' => 'leaf',
          'value_type' => 'uniline'
        },
        'type' => 'list'
      },
      'copyright',
      {
        'cargo' => {
          'type' => 'leaf',
          'value_type' => 'uniline'
        },
        'type' => 'list'
      },
      'class',
      {
        'assert' => {
          '1_load_class' => {
            'code' => 'return 1 unless defined $_;return Mouse::Util::load_class($_);',
            'msg' => 'Error while loading $_ class '
          },
          '2_class_inherit' => {
            'code' => 'not defined $_ or $_->isa("Config::Model::Node")',
            'msg' => 'class $_ must inherit Config::Model::Node'
          }
        },
        'description' => 'Perl class name used to override the default implementation of a configuration node. This Perl class must inherit L<Config::Model::Node>. Use with care.',
        'summary' => 'Override implementation of configuration node',
        'type' => 'leaf',
        'value_type' => 'uniline'
      },
      'element',
      {
        'cargo' => {
          'config_class_name' => 'Itself::Element',
          'type' => 'node'
        },
        'description' => 'Specify the elements names of this configuration class.',
        'index_type' => 'string',
        'level' => 'important',
        'ordered' => 1,
        'type' => 'hash'
      },
      'include',
      {
        'cargo' => {
          'refer_to' => '! class',
          'type' => 'leaf',
          'value_type' => 'reference'
        },
        'description' => 'Include the element description of another class into this class.',
        'type' => 'list'
      },
      'include_backend',
      {
        'cargo' => {
          'refer_to' => '! class',
          'type' => 'leaf',
          'value_type' => 'reference'
        },
        'description' => 'Include the read/write specification of another class into this class.',
        'type' => 'list'
      },
      'include_after',
      {
        'description' => 'insert the included elements after a specific element. By default, included elements are placed before all other elements.',
        'refer_to' => '- element',
        'type' => 'leaf',
        'value_type' => 'reference'
      },
      'generated_by',
      {
        'description' => 'When set, this class was generated by some program. You should not edit this class as your modifications may be clobbered later on when the class is regenerated.',
        'type' => 'leaf',
        'value_type' => 'uniline'
      },
      'rw_config',
      {
        'config_class_name' => 'Itself::ConfigReadWrite',
        'description' => 'Specify the backend used to read and write configuration data. See L<Config::Model::BackendMgr> for details',
        'type' => 'node'
      },
      'accept',
      {
        'cargo' => {
          'config_class_name' => 'Itself::ConfigAccept',
          'type' => 'node'
        },
        'description' => 'Specifies names of the elements this configuration class accepts as valid. The key of the hash is a regular expression that are be tested against
           candidate parameters. When the parameter matches the regular expression,
           a new parameter is created in the model using the description provided
           in the value of this hash key. Note that the regexp must match the whole name
           of the potential parameter. I.e. the specified regexp is eval\'ed
           with a leading C<^> and a trailing C<$>.',
        'index_type' => 'string',
        'ordered' => 1,
        'type' => 'hash'
      }
    ],
    'license' => 'LGPL-2',
    'name' => 'Itself::Class'
  },
  {
    'element' => [
      'config_dir',
      {
        'type' => 'leaf',
        'value_type' => 'uniline'
      },
      'os_config_dir',
      {
        'cargo' => {
          'type' => 'leaf',
          'value_type' => 'uniline'
        },
        'description' => 'Specify and alternate location of a configuration directory depending on the OS (as returned by C<$^O> or C<$Config{\'osname\'}>, see L<perlport/PLATFORMS>) Common values for C<$^O> are \'linux\', \'MSWin32\', \'darwin\'',
        'index_type' => 'string',
        'summary' => 'configuration file directory for specific OS',
        'type' => 'hash'
      },
      'file',
      {
        'description' => 'specify the configuration file name. This parameter may not be applicable depending on your application. It may also be hardcoded in a custom backend. If not specified, the instance name is used as base name for your configuration file. The configuration file namecan be specified with &index() or &element function. See L<backend specifications|http://search.cpan.org/dist/Config-Model/lib/Config/Model/BackendMgr.pm#Backend_specification> and L<Config::Model::Role::ComputeFunction>.',
        'summary' => 'target configuration file name',
        'type' => 'leaf',
        'value_type' => 'uniline'
      }
    ],
    'name' => 'Itself::ConfigReadWrite::DefaultLayer'
  },
  {
    'element' => [
      'backend',
      {
        'choice' => [
          'cds_file',
          'perl_file',
          'custom'
        ],
        'class' => 'Config::Model::Itself::BackendDetector',
        'description' => 'specifies the backend to store permanently configuration data.',
        'help' => {
          'IniFile' => 'Ini file format. Beware that the structure of your model must match the limitations of the INI file format, i.e only a 2 levels hierarchy. Configuration filename is made with instance name',
          'cds_file' => 'file with config data string. This is Config::Model own serialisation format, designed to be compact and readable. Configuration filename is made with instance name',
          'custom' => 'deprecated',
          'perl_file' => 'file with a perl data structure. Configuration filename is made with instance name'
        },
        'replace' => {
          'cds' => 'cds_file',
          'ini' => 'IniFile',
          'ini_file' => 'IniFile',
          'perl' => 'perl_file'
        },
        'type' => 'leaf',
        'value_type' => 'enum',
        'warn_if_match' => {
          '^custom$' => {
            'msg' => 'custom backend are deprecated'
          }
        }
      },
      'function',
      {
        'level' => 'hidden',
        'status' => 'deprecated',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'custom\'',
            {
              'level' => 'normal',
              'upstream_default' => 'read'
            }
          ]
        }
      },
      'auto_create',
      {
        'summary' => 'Creates configuration files as needed',
        'type' => 'leaf',
        'upstream_default' => 0,
        'value_type' => 'boolean'
      },
      'yaml_class',
      {
        'description' => 'Specify the YAML class that is used to load and dump YAML files. Defaults to L<YAML::Tiny>. See L<yaml_class doc|Config::Model::Backend::Yaml/yaml_class> for details on  why another YAML class can suit your configuration file needs.',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => 'YAML::Tiny',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'Yaml\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'file_mode',
      {
        'description' => 'specify the configuration file mode. C<file_mode> parameter can be used to set the mode of the written file. C<file_mode> value can be in any form supported by L<Path::Tiny/chmod>.',
        'summary' => 'configuration file mode',
        'type' => 'leaf',
        'value_type' => 'uniline'
      },
      'default_layer',
      {
        'config_class_name' => 'Itself::ConfigReadWrite::DefaultLayer',
        'description' => 'Specifies where to find a global configuration file that specifies default values. For instance, this is used by OpenSSH to specify a global configuration file (C</etc/ssh/ssh_config>) that is overridden by user\'s file',
        'summary' => 'How to find default values in a global config file',
        'type' => 'node'
      },
      'class',
      {
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'custom\'',
            {
              'level' => 'normal',
              'mandatory' => 1
            }
          ]
        }
      },
      'store_class_in_hash',
      {
        'description' => 'Specify element hash name that contains all INI classes. See L<Config::Model::Backend::IniFile/"Arbitrary class name">',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'section_map',
      {
        'cargo' => {
          'type' => 'leaf',
          'value_type' => 'uniline'
        },
        'description' => 'Specify element name that contains one INI class. E.g. to store INI class [foo] in element Foo, specify { foo => "Foo" } ',
        'index_type' => 'string',
        'level' => 'hidden',
        'type' => 'hash',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'split_list_value',
      {
        'description' => 'Regexp to split the value read from ini file. Usually "\\s+" or "[,\\s]"',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'split_check_list_value',
      {
        'description' => 'Regexp to split the value read from ini file. Usually "\\s+" or "[,\\s]"',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'assign_char',
      {
        'description' => 'Character used to assign value in INI file. Default is C<=>. See L<details|Config::Model::Backend::IniFile/"Handle key value files">',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => '#',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'assign_with',
      {
        'description' => 'String used write assignment in INI file. Default is "C< = >". See L<details|Config::Model::Backend::IniFile/"Handle key value files">',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => '#',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'join_list_value',
      {
        'description' => 'string to join list values before writing the entry in ini file. Usually " " or ", "',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'join_check_list_value',
      {
        'description' => 'string to join checked items names before writing the entry in the ini file. Usually " " or ", "',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'write_boolean_as',
      {
        'cargo' => {
          'type' => 'leaf',
          'value_type' => 'uniline'
        },
        'description' => 'Specify how to write a boolean value in config file. Suggested values are "no","yes". ',
        'max_index' => 1,
        'type' => 'list'
      },
      'force_lc_section',
      {
        'description' => 'force section to be lowercase',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => 0,
        'value_type' => 'boolean',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'force_lc_key',
      {
        'description' => 'force key names to be lowercase',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => 0,
        'value_type' => 'boolean',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'force_lc_value',
      {
        'description' => 'force values to be lowercase',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => 0,
        'value_type' => 'boolean',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'full_dump',
      {
        'description' => 'Also dump default values in the data structure. Useful if the dumped configuration data will be used by the application. (default is yes)',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => '1',
        'value_type' => 'boolean',
        'warp' => {
          'follow' => {
            'backend' => '- backend'
          },
          'rules' => [
            '$backend =~ /yaml|perl/i',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'comment_delimiter',
      {
        'description' => 'list of characters that start a comment. When more that one character is used. the first one is used to write back comment. For instance, value "#;" indicate that a comments can start with "#" or ";" and that all comments are written back with "#".',
        'level' => 'hidden',
        'type' => 'leaf',
        'upstream_default' => '#',
        'value_type' => 'uniline',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'quote_value',
      {
        'choice' => [
          'shell_style'
        ],
        'description' => 'Specify how to handle quoted values. By default, quoted values are left as is. With C<shell_style>, value are parsed and unquoted like in a shell. Values containing a space are written back with double quotes.',
        'level' => 'hidden',
        'type' => 'leaf',
        'value_type' => 'enum',
        'warp' => {
          'follow' => {
            'f1' => '- backend'
          },
          'rules' => [
            '$f1 eq \'IniFile\'',
            {
              'level' => 'normal'
            }
          ]
        }
      },
      'auto_delete',
      {
        'description' => 'Delete configuration files when no information is left in there. This may happen when data is removed by user. This is mostly useful when the  configuration of an application is made of several files.',
        'summary' => 'Delete empty configuration file',
        'type' => 'leaf',
        'upstream_default' => 0,
        'value_type' => 'boolean'
      }
    ],
    'include' => [
      'Itself::ConfigReadWrite::DefaultLayer'
    ],
    'include_after' => 'backend',
    'name' => 'Itself::ConfigReadWrite'
  },
  {
    'element' => [
      'name_match',
      {
        'status' => 'deprecated',
        'type' => 'leaf',
        'upstream_default' => '.*',
        'value_type' => 'uniline'
      },
      'accept_after',
      {
        'description' => 'specify where to insert accepted element. This does not change the behavior and helps generating more consistent  user interfaces',
        'refer_to' => '- - element',
        'type' => 'leaf',
        'value_type' => 'reference'
      }
    ],
    'include' => [
      'Itself::Element'
    ],
    'include_after' => 'accept_after',
    'name' => 'Itself::ConfigAccept'
  }
]
;




