#
# @file    TestL3ModelHistory.py
# @brief   test for ModelHistory on any SBase object
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3ModelHistory.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml

def wrapString(s):
  return s
  pass


class TestL3ModelHistory(unittest.TestCase):

  global c
  c = None
  global d
  d = None
  global m
  m = None

  def equals(self, *x):
    if len(x) == 2:
      return x[0] == x[1]
    elif len(x) == 1:
      return x[0] == self.OSS.str()

  def setUp(self):
    filename = "../../sbml/annotation/test/test-data/annotationL3.xml"
    self.d = libsbml.readSBML(filename)
    self.m = self.d.getModel()
    self.c = self.m.getCompartment(0)
    pass  

  def tearDown(self):
    self.d = None
    pass  

  def test_L3ModelHistory_delete(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.c)
    n1 = libsbml.RDFAnnotationParser.deleteRDFAnnotation(node)
    expected =  "<annotation/>";
    self.assertTrue( n1.getNumChildren() == 0 )
    self.assertTrue( n1.getName() ==  "annotation" )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    node = None
    pass  

  def test_L3ModelHistory_deleteWithOther(self):
    self.c = self.m.getCompartment(1)
    node = libsbml.RDFAnnotationParser.deleteRDFAnnotation(self.c.getAnnotation())
    expected = wrapString("<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,node.toXMLString()) )
    pass  

  def test_L3ModelHistory_deleteWithOutOther(self):
    self.c = self.m.getCompartment(2)
    node = self.c.getAnnotation()
    expected = wrapString("<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,node.toXMLString()) )
    pass  

  def test_L3ModelHistory_delete_Model(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.m)
    n1 = libsbml.RDFAnnotationParser.deleteRDFAnnotation(node)
    expected =  "<annotation/>";
    self.assertTrue( n1.getNumChildren() == 0 )
    self.assertTrue( n1.getName() ==  "annotation" )
    self.assertEqual( True, self.equals(expected,n1.toXMLString()) )
    node = None
    pass  

  def test_L3ModelHistory_getModelHistory(self):
    self.assertTrue( (self.c == None) == False )
    history = self.c.getModelHistory()
    self.assertTrue( history != None )
    mc = history.getCreator(0)
    self.assertTrue((  "Le Novere" == mc.getFamilyName() ))
    self.assertTrue((  "Nicolas" == mc.getGivenName() ))
    self.assertTrue((  "lenov@ebi.ac.uk" == mc.getEmail() ))
    self.assertTrue((  "EMBL-EBI" == mc.getOrganisation() ))
    date = history.getCreatedDate()
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 2 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2005-02-02T14:56:11Z" == date.getDateAsString() ))
    date = history.getModifiedDate()
    self.assertTrue( date.getYear() == 2006 )
    self.assertTrue( date.getMonth() == 5 )
    self.assertTrue( date.getDay() == 30 )
    self.assertTrue( date.getHour() == 10 )
    self.assertTrue( date.getMinute() == 46 )
    self.assertTrue( date.getSecond() == 2 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2006-05-30T10:46:02Z" == date.getDateAsString() ))
    pass  

  def test_L3ModelHistory_getModelHistory_Model(self):
    self.assertTrue( (self.m == None) == False )
    history = self.m.getModelHistory()
    self.assertTrue( history != None )
    mc = history.getCreator(0)
    self.assertTrue((  "Le Novere" == mc.getFamilyName() ))
    self.assertTrue((  "Nicolas" == mc.getGivenName() ))
    self.assertTrue((  "lenov@ebi.ac.uk" == mc.getEmail() ))
    self.assertTrue((  "EMBL-EBI" == mc.getOrganisation() ))
    date = history.getCreatedDate()
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 2 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2005-02-02T14:56:11Z" == date.getDateAsString() ))
    date = history.getModifiedDate()
    self.assertTrue( date.getYear() == 2006 )
    self.assertTrue( date.getMonth() == 5 )
    self.assertTrue( date.getDay() == 30 )
    self.assertTrue( date.getHour() == 10 )
    self.assertTrue( date.getMinute() == 46 )
    self.assertTrue( date.getSecond() == 2 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2006-05-30T10:46:02Z" == date.getDateAsString() ))
    pass  

  def test_L3ModelHistory_parseModelHistory(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.c)
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 4 )
    creator = desc.getChild(0)
    self.assertTrue((  "creator" == creator.getName() ))
    self.assertTrue((  "dcterms" == creator.getPrefix() ))
    self.assertTrue( creator.getNumChildren() == 1 )
    Bag = creator.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 1 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 3 )
    N = li.getChild(0)
    self.assertTrue((  "N" == N.getName() ))
    self.assertTrue((  "vCard" == N.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == N.getURI() ))
    self.assertTrue( N.getNumChildren() == 2 )
    Family = N.getChild(0)
    self.assertTrue((  "Family" == Family.getName() ))
    self.assertTrue((  "vCard" == Family.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Family.getURI() ))
    self.assertTrue( Family.getNumChildren() == 1 )
    Given = N.getChild(1)
    self.assertTrue((  "Given" == Given.getName() ))
    self.assertTrue((  "vCard" == Given.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Given.getURI() ))
    self.assertTrue( Given.getNumChildren() == 1 )
    EMAIL = li.getChild(1)
    self.assertTrue((  "EMAIL" == EMAIL.getName() ))
    self.assertTrue((  "vCard" == EMAIL.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == EMAIL.getURI() ))
    self.assertTrue( EMAIL.getNumChildren() == 1 )
    ORG = li.getChild(2)
    self.assertTrue((  "ORG" == ORG.getName() ))
    self.assertTrue((  "vCard" == ORG.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == ORG.getURI() ))
    self.assertTrue( ORG.getNumChildren() == 1 )
    Orgname = ORG.getChild(0)
    self.assertTrue((  "Orgname" == Orgname.getName() ))
    self.assertTrue((  "vCard" == Orgname.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Orgname.getURI() ))
    self.assertTrue( Orgname.getNumChildren() == 1 )
    created = desc.getChild(1)
    self.assertTrue((  "created" == created.getName() ))
    self.assertTrue((  "dcterms" == created.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == created.getURI() ))
    self.assertTrue( created.getNumChildren() == 1 )
    cr_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == cr_date.getName() ))
    self.assertTrue((  "dcterms" == cr_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == cr_date.getURI() ))
    self.assertTrue( cr_date.getNumChildren() == 1 )
    modified = desc.getChild(2)
    self.assertTrue((  "modified" == modified.getName() ))
    self.assertTrue((  "dcterms" == modified.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == modified.getURI() ))
    self.assertTrue( modified.getNumChildren() == 1 )
    mo_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == mo_date.getName() ))
    self.assertTrue((  "dcterms" == mo_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == mo_date.getURI() ))
    self.assertTrue( mo_date.getNumChildren() == 1 )
    node = None
    pass  

  def test_L3ModelHistory_parseModelHistory_Model(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.m)
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 4 )
    creator = desc.getChild(0)
    self.assertTrue((  "creator" == creator.getName() ))
    self.assertTrue((  "dcterms" == creator.getPrefix() ))
    self.assertTrue( creator.getNumChildren() == 1 )
    Bag = creator.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 1 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 3 )
    N = li.getChild(0)
    self.assertTrue((  "N" == N.getName() ))
    self.assertTrue((  "vCard" == N.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == N.getURI() ))
    self.assertTrue( N.getNumChildren() == 2 )
    Family = N.getChild(0)
    self.assertTrue((  "Family" == Family.getName() ))
    self.assertTrue((  "vCard" == Family.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Family.getURI() ))
    self.assertTrue( Family.getNumChildren() == 1 )
    Given = N.getChild(1)
    self.assertTrue((  "Given" == Given.getName() ))
    self.assertTrue((  "vCard" == Given.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Given.getURI() ))
    self.assertTrue( Given.getNumChildren() == 1 )
    EMAIL = li.getChild(1)
    self.assertTrue((  "EMAIL" == EMAIL.getName() ))
    self.assertTrue((  "vCard" == EMAIL.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == EMAIL.getURI() ))
    self.assertTrue( EMAIL.getNumChildren() == 1 )
    ORG = li.getChild(2)
    self.assertTrue((  "ORG" == ORG.getName() ))
    self.assertTrue((  "vCard" == ORG.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == ORG.getURI() ))
    self.assertTrue( ORG.getNumChildren() == 1 )
    Orgname = ORG.getChild(0)
    self.assertTrue((  "Orgname" == Orgname.getName() ))
    self.assertTrue((  "vCard" == Orgname.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Orgname.getURI() ))
    self.assertTrue( Orgname.getNumChildren() == 1 )
    created = desc.getChild(1)
    self.assertTrue((  "created" == created.getName() ))
    self.assertTrue((  "dcterms" == created.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == created.getURI() ))
    self.assertTrue( created.getNumChildren() == 1 )
    cr_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == cr_date.getName() ))
    self.assertTrue((  "dcterms" == cr_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == cr_date.getURI() ))
    self.assertTrue( cr_date.getNumChildren() == 1 )
    modified = desc.getChild(2)
    self.assertTrue((  "modified" == modified.getName() ))
    self.assertTrue((  "dcterms" == modified.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == modified.getURI() ))
    self.assertTrue( modified.getNumChildren() == 1 )
    mo_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == mo_date.getName() ))
    self.assertTrue((  "dcterms" == mo_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == mo_date.getURI() ))
    self.assertTrue( mo_date.getNumChildren() == 1 )
    node = None
    pass  


def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestL3ModelHistory))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
