// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SHL_2S_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SHL_2S_2OPIMM_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_shl_2S_2OPIMM[] = {
  0xfffffffd, 0xfffffffe,
  0xfffffffa, 0xfffffffc,
  0xfffffff4, 0xfffffff8,
  0xffffffe8, 0xfffffff0,
  0xffffffd0, 0xffffffe0,
  0xffffffa0, 0xffffffc0,
  0xffffff40, 0xffffff80,
  0xfffffe80, 0xffffff00,
  0xfffffd00, 0xfffffe00,
  0xfffffa00, 0xfffffc00,
  0xfffff400, 0xfffff800,
  0xffffe800, 0xfffff000,
  0xffffd000, 0xffffe000,
  0xffffa000, 0xffffc000,
  0xffff4000, 0xffff8000,
  0xfffe8000, 0xffff0000,
  0xfffd0000, 0xfffe0000,
  0xfffa0000, 0xfffc0000,
  0xfff40000, 0xfff80000,
  0xffe80000, 0xfff00000,
  0xffd00000, 0xffe00000,
  0xffa00000, 0xffc00000,
  0xff400000, 0xff800000,
  0xfe800000, 0xff000000,
  0xfd000000, 0xfe000000,
  0xfa000000, 0xfc000000,
  0xf4000000, 0xf8000000,
  0xe8000000, 0xf0000000,
  0xd0000000, 0xe0000000,
  0xa0000000, 0xc0000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0xfffffffe, 0xffffffff,
  0xfffffffc, 0xfffffffe,
  0xfffffff8, 0xfffffffc,
  0xfffffff0, 0xfffffff8,
  0xffffffe0, 0xfffffff0,
  0xffffffc0, 0xffffffe0,
  0xffffff80, 0xffffffc0,
  0xffffff00, 0xffffff80,
  0xfffffe00, 0xffffff00,
  0xfffffc00, 0xfffffe00,
  0xfffff800, 0xfffffc00,
  0xfffff000, 0xfffff800,
  0xffffe000, 0xfffff000,
  0xffffc000, 0xffffe000,
  0xffff8000, 0xffffc000,
  0xffff0000, 0xffff8000,
  0xfffe0000, 0xffff0000,
  0xfffc0000, 0xfffe0000,
  0xfff80000, 0xfffc0000,
  0xfff00000, 0xfff80000,
  0xffe00000, 0xfff00000,
  0xffc00000, 0xffe00000,
  0xff800000, 0xffc00000,
  0xff000000, 0xff800000,
  0xfe000000, 0xff000000,
  0xfc000000, 0xfe000000,
  0xf8000000, 0xfc000000,
  0xf0000000, 0xf8000000,
  0xe0000000, 0xf0000000,
  0xc0000000, 0xe0000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0xffffffff, 0x00000000,
  0xfffffffe, 0x00000000,
  0xfffffffc, 0x00000000,
  0xfffffff8, 0x00000000,
  0xfffffff0, 0x00000000,
  0xffffffe0, 0x00000000,
  0xffffffc0, 0x00000000,
  0xffffff80, 0x00000000,
  0xffffff00, 0x00000000,
  0xfffffe00, 0x00000000,
  0xfffffc00, 0x00000000,
  0xfffff800, 0x00000000,
  0xfffff000, 0x00000000,
  0xffffe000, 0x00000000,
  0xffffc000, 0x00000000,
  0xffff8000, 0x00000000,
  0xffff0000, 0x00000000,
  0xfffe0000, 0x00000000,
  0xfffc0000, 0x00000000,
  0xfff80000, 0x00000000,
  0xfff00000, 0x00000000,
  0xffe00000, 0x00000000,
  0xffc00000, 0x00000000,
  0xff800000, 0x00000000,
  0xff000000, 0x00000000,
  0xfe000000, 0x00000000,
  0xfc000000, 0x00000000,
  0xf8000000, 0x00000000,
  0xf0000000, 0x00000000,
  0xe0000000, 0x00000000,
  0xc0000000, 0x00000000,
  0x80000000, 0x00000000,
  0x00000000, 0x00000001,
  0x00000000, 0x00000002,
  0x00000000, 0x00000004,
  0x00000000, 0x00000008,
  0x00000000, 0x00000010,
  0x00000000, 0x00000020,
  0x00000000, 0x00000040,
  0x00000000, 0x00000080,
  0x00000000, 0x00000100,
  0x00000000, 0x00000200,
  0x00000000, 0x00000400,
  0x00000000, 0x00000800,
  0x00000000, 0x00001000,
  0x00000000, 0x00002000,
  0x00000000, 0x00004000,
  0x00000000, 0x00008000,
  0x00000000, 0x00010000,
  0x00000000, 0x00020000,
  0x00000000, 0x00040000,
  0x00000000, 0x00080000,
  0x00000000, 0x00100000,
  0x00000000, 0x00200000,
  0x00000000, 0x00400000,
  0x00000000, 0x00800000,
  0x00000000, 0x01000000,
  0x00000000, 0x02000000,
  0x00000000, 0x04000000,
  0x00000000, 0x08000000,
  0x00000000, 0x10000000,
  0x00000000, 0x20000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
  0x00000001, 0x00000002,
  0x00000002, 0x00000004,
  0x00000004, 0x00000008,
  0x00000008, 0x00000010,
  0x00000010, 0x00000020,
  0x00000020, 0x00000040,
  0x00000040, 0x00000080,
  0x00000080, 0x00000100,
  0x00000100, 0x00000200,
  0x00000200, 0x00000400,
  0x00000400, 0x00000800,
  0x00000800, 0x00001000,
  0x00001000, 0x00002000,
  0x00002000, 0x00004000,
  0x00004000, 0x00008000,
  0x00008000, 0x00010000,
  0x00010000, 0x00020000,
  0x00020000, 0x00040000,
  0x00040000, 0x00080000,
  0x00080000, 0x00100000,
  0x00100000, 0x00200000,
  0x00200000, 0x00400000,
  0x00400000, 0x00800000,
  0x00800000, 0x01000000,
  0x01000000, 0x02000000,
  0x02000000, 0x04000000,
  0x04000000, 0x08000000,
  0x08000000, 0x10000000,
  0x10000000, 0x20000000,
  0x20000000, 0x40000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0x00000002, 0x00000020,
  0x00000004, 0x00000040,
  0x00000008, 0x00000080,
  0x00000010, 0x00000100,
  0x00000020, 0x00000200,
  0x00000040, 0x00000400,
  0x00000080, 0x00000800,
  0x00000100, 0x00001000,
  0x00000200, 0x00002000,
  0x00000400, 0x00004000,
  0x00000800, 0x00008000,
  0x00001000, 0x00010000,
  0x00002000, 0x00020000,
  0x00004000, 0x00040000,
  0x00008000, 0x00080000,
  0x00010000, 0x00100000,
  0x00020000, 0x00200000,
  0x00040000, 0x00400000,
  0x00080000, 0x00800000,
  0x00100000, 0x01000000,
  0x00200000, 0x02000000,
  0x00400000, 0x04000000,
  0x00800000, 0x08000000,
  0x01000000, 0x10000000,
  0x02000000, 0x20000000,
  0x04000000, 0x40000000,
  0x08000000, 0x80000000,
  0x10000000, 0x00000000,
  0x20000000, 0x00000000,
  0x40000000, 0x00000000,
  0x80000000, 0x00000000,
  0x00000000, 0x00000000,
  0x00000020, 0x0000007d,
  0x00000040, 0x000000fa,
  0x00000080, 0x000001f4,
  0x00000100, 0x000003e8,
  0x00000200, 0x000007d0,
  0x00000400, 0x00000fa0,
  0x00000800, 0x00001f40,
  0x00001000, 0x00003e80,
  0x00002000, 0x00007d00,
  0x00004000, 0x0000fa00,
  0x00008000, 0x0001f400,
  0x00010000, 0x0003e800,
  0x00020000, 0x0007d000,
  0x00040000, 0x000fa000,
  0x00080000, 0x001f4000,
  0x00100000, 0x003e8000,
  0x00200000, 0x007d0000,
  0x00400000, 0x00fa0000,
  0x00800000, 0x01f40000,
  0x01000000, 0x03e80000,
  0x02000000, 0x07d00000,
  0x04000000, 0x0fa00000,
  0x08000000, 0x1f400000,
  0x10000000, 0x3e800000,
  0x20000000, 0x7d000000,
  0x40000000, 0xfa000000,
  0x80000000, 0xf4000000,
  0x00000000, 0xe8000000,
  0x00000000, 0xd0000000,
  0x00000000, 0xa0000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
  0x0000007d, 0x0000007e,
  0x000000fa, 0x000000fc,
  0x000001f4, 0x000001f8,
  0x000003e8, 0x000003f0,
  0x000007d0, 0x000007e0,
  0x00000fa0, 0x00000fc0,
  0x00001f40, 0x00001f80,
  0x00003e80, 0x00003f00,
  0x00007d00, 0x00007e00,
  0x0000fa00, 0x0000fc00,
  0x0001f400, 0x0001f800,
  0x0003e800, 0x0003f000,
  0x0007d000, 0x0007e000,
  0x000fa000, 0x000fc000,
  0x001f4000, 0x001f8000,
  0x003e8000, 0x003f0000,
  0x007d0000, 0x007e0000,
  0x00fa0000, 0x00fc0000,
  0x01f40000, 0x01f80000,
  0x03e80000, 0x03f00000,
  0x07d00000, 0x07e00000,
  0x0fa00000, 0x0fc00000,
  0x1f400000, 0x1f800000,
  0x3e800000, 0x3f000000,
  0x7d000000, 0x7e000000,
  0xfa000000, 0xfc000000,
  0xf4000000, 0xf8000000,
  0xe8000000, 0xf0000000,
  0xd0000000, 0xe0000000,
  0xa0000000, 0xc0000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0x0000007e, 0x0000007f,
  0x000000fc, 0x000000fe,
  0x000001f8, 0x000001fc,
  0x000003f0, 0x000003f8,
  0x000007e0, 0x000007f0,
  0x00000fc0, 0x00000fe0,
  0x00001f80, 0x00001fc0,
  0x00003f00, 0x00003f80,
  0x00007e00, 0x00007f00,
  0x0000fc00, 0x0000fe00,
  0x0001f800, 0x0001fc00,
  0x0003f000, 0x0003f800,
  0x0007e000, 0x0007f000,
  0x000fc000, 0x000fe000,
  0x001f8000, 0x001fc000,
  0x003f0000, 0x003f8000,
  0x007e0000, 0x007f0000,
  0x00fc0000, 0x00fe0000,
  0x01f80000, 0x01fc0000,
  0x03f00000, 0x03f80000,
  0x07e00000, 0x07f00000,
  0x0fc00000, 0x0fe00000,
  0x1f800000, 0x1fc00000,
  0x3f000000, 0x3f800000,
  0x7e000000, 0x7f000000,
  0xfc000000, 0xfe000000,
  0xf8000000, 0xfc000000,
  0xf0000000, 0xf8000000,
  0xe0000000, 0xf0000000,
  0xc0000000, 0xe0000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0x0000007f, 0x00007ffd,
  0x000000fe, 0x0000fffa,
  0x000001fc, 0x0001fff4,
  0x000003f8, 0x0003ffe8,
  0x000007f0, 0x0007ffd0,
  0x00000fe0, 0x000fffa0,
  0x00001fc0, 0x001fff40,
  0x00003f80, 0x003ffe80,
  0x00007f00, 0x007ffd00,
  0x0000fe00, 0x00fffa00,
  0x0001fc00, 0x01fff400,
  0x0003f800, 0x03ffe800,
  0x0007f000, 0x07ffd000,
  0x000fe000, 0x0fffa000,
  0x001fc000, 0x1fff4000,
  0x003f8000, 0x3ffe8000,
  0x007f0000, 0x7ffd0000,
  0x00fe0000, 0xfffa0000,
  0x01fc0000, 0xfff40000,
  0x03f80000, 0xffe80000,
  0x07f00000, 0xffd00000,
  0x0fe00000, 0xffa00000,
  0x1fc00000, 0xff400000,
  0x3f800000, 0xfe800000,
  0x7f000000, 0xfd000000,
  0xfe000000, 0xfa000000,
  0xfc000000, 0xf4000000,
  0xf8000000, 0xe8000000,
  0xf0000000, 0xd0000000,
  0xe0000000, 0xa0000000,
  0xc0000000, 0x40000000,
  0x80000000, 0x80000000,
  0x00007ffd, 0x00007ffe,
  0x0000fffa, 0x0000fffc,
  0x0001fff4, 0x0001fff8,
  0x0003ffe8, 0x0003fff0,
  0x0007ffd0, 0x0007ffe0,
  0x000fffa0, 0x000fffc0,
  0x001fff40, 0x001fff80,
  0x003ffe80, 0x003fff00,
  0x007ffd00, 0x007ffe00,
  0x00fffa00, 0x00fffc00,
  0x01fff400, 0x01fff800,
  0x03ffe800, 0x03fff000,
  0x07ffd000, 0x07ffe000,
  0x0fffa000, 0x0fffc000,
  0x1fff4000, 0x1fff8000,
  0x3ffe8000, 0x3fff0000,
  0x7ffd0000, 0x7ffe0000,
  0xfffa0000, 0xfffc0000,
  0xfff40000, 0xfff80000,
  0xffe80000, 0xfff00000,
  0xffd00000, 0xffe00000,
  0xffa00000, 0xffc00000,
  0xff400000, 0xff800000,
  0xfe800000, 0xff000000,
  0xfd000000, 0xfe000000,
  0xfa000000, 0xfc000000,
  0xf4000000, 0xf8000000,
  0xe8000000, 0xf0000000,
  0xd0000000, 0xe0000000,
  0xa0000000, 0xc0000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0x00007ffe, 0x00007fff,
  0x0000fffc, 0x0000fffe,
  0x0001fff8, 0x0001fffc,
  0x0003fff0, 0x0003fff8,
  0x0007ffe0, 0x0007fff0,
  0x000fffc0, 0x000fffe0,
  0x001fff80, 0x001fffc0,
  0x003fff00, 0x003fff80,
  0x007ffe00, 0x007fff00,
  0x00fffc00, 0x00fffe00,
  0x01fff800, 0x01fffc00,
  0x03fff000, 0x03fff800,
  0x07ffe000, 0x07fff000,
  0x0fffc000, 0x0fffe000,
  0x1fff8000, 0x1fffc000,
  0x3fff0000, 0x3fff8000,
  0x7ffe0000, 0x7fff0000,
  0xfffc0000, 0xfffe0000,
  0xfff80000, 0xfffc0000,
  0xfff00000, 0xfff80000,
  0xffe00000, 0xfff00000,
  0xffc00000, 0xffe00000,
  0xff800000, 0xffc00000,
  0xff000000, 0xff800000,
  0xfe000000, 0xff000000,
  0xfc000000, 0xfe000000,
  0xf8000000, 0xfc000000,
  0xf0000000, 0xf8000000,
  0xe0000000, 0xf0000000,
  0xc0000000, 0xe0000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0x00007fff, 0x33333333,
  0x0000fffe, 0x66666666,
  0x0001fffc, 0xcccccccc,
  0x0003fff8, 0x99999998,
  0x0007fff0, 0x33333330,
  0x000fffe0, 0x66666660,
  0x001fffc0, 0xccccccc0,
  0x003fff80, 0x99999980,
  0x007fff00, 0x33333300,
  0x00fffe00, 0x66666600,
  0x01fffc00, 0xcccccc00,
  0x03fff800, 0x99999800,
  0x07fff000, 0x33333000,
  0x0fffe000, 0x66666000,
  0x1fffc000, 0xccccc000,
  0x3fff8000, 0x99998000,
  0x7fff0000, 0x33330000,
  0xfffe0000, 0x66660000,
  0xfffc0000, 0xcccc0000,
  0xfff80000, 0x99980000,
  0xfff00000, 0x33300000,
  0xffe00000, 0x66600000,
  0xffc00000, 0xccc00000,
  0xff800000, 0x99800000,
  0xff000000, 0x33000000,
  0xfe000000, 0x66000000,
  0xfc000000, 0xcc000000,
  0xf8000000, 0x98000000,
  0xf0000000, 0x30000000,
  0xe0000000, 0x60000000,
  0xc0000000, 0xc0000000,
  0x80000000, 0x80000000,
  0x33333333, 0x55555555,
  0x66666666, 0xaaaaaaaa,
  0xcccccccc, 0x55555554,
  0x99999998, 0xaaaaaaa8,
  0x33333330, 0x55555550,
  0x66666660, 0xaaaaaaa0,
  0xccccccc0, 0x55555540,
  0x99999980, 0xaaaaaa80,
  0x33333300, 0x55555500,
  0x66666600, 0xaaaaaa00,
  0xcccccc00, 0x55555400,
  0x99999800, 0xaaaaa800,
  0x33333000, 0x55555000,
  0x66666000, 0xaaaaa000,
  0xccccc000, 0x55554000,
  0x99998000, 0xaaaa8000,
  0x33330000, 0x55550000,
  0x66660000, 0xaaaa0000,
  0xcccc0000, 0x55540000,
  0x99980000, 0xaaa80000,
  0x33300000, 0x55500000,
  0x66600000, 0xaaa00000,
  0xccc00000, 0x55400000,
  0x99800000, 0xaa800000,
  0x33000000, 0x55000000,
  0x66000000, 0xaa000000,
  0xcc000000, 0x54000000,
  0x98000000, 0xa8000000,
  0x30000000, 0x50000000,
  0x60000000, 0xa0000000,
  0xc0000000, 0x40000000,
  0x80000000, 0x80000000,
  0x55555555, 0x7ffffffd,
  0xaaaaaaaa, 0xfffffffa,
  0x55555554, 0xfffffff4,
  0xaaaaaaa8, 0xffffffe8,
  0x55555550, 0xffffffd0,
  0xaaaaaaa0, 0xffffffa0,
  0x55555540, 0xffffff40,
  0xaaaaaa80, 0xfffffe80,
  0x55555500, 0xfffffd00,
  0xaaaaaa00, 0xfffffa00,
  0x55555400, 0xfffff400,
  0xaaaaa800, 0xffffe800,
  0x55555000, 0xffffd000,
  0xaaaaa000, 0xffffa000,
  0x55554000, 0xffff4000,
  0xaaaa8000, 0xfffe8000,
  0x55550000, 0xfffd0000,
  0xaaaa0000, 0xfffa0000,
  0x55540000, 0xfff40000,
  0xaaa80000, 0xffe80000,
  0x55500000, 0xffd00000,
  0xaaa00000, 0xffa00000,
  0x55400000, 0xff400000,
  0xaa800000, 0xfe800000,
  0x55000000, 0xfd000000,
  0xaa000000, 0xfa000000,
  0x54000000, 0xf4000000,
  0xa8000000, 0xe8000000,
  0x50000000, 0xd0000000,
  0xa0000000, 0xa0000000,
  0x40000000, 0x40000000,
  0x80000000, 0x80000000,
  0x7ffffffd, 0x7ffffffe,
  0xfffffffa, 0xfffffffc,
  0xfffffff4, 0xfffffff8,
  0xffffffe8, 0xfffffff0,
  0xffffffd0, 0xffffffe0,
  0xffffffa0, 0xffffffc0,
  0xffffff40, 0xffffff80,
  0xfffffe80, 0xffffff00,
  0xfffffd00, 0xfffffe00,
  0xfffffa00, 0xfffffc00,
  0xfffff400, 0xfffff800,
  0xffffe800, 0xfffff000,
  0xffffd000, 0xffffe000,
  0xffffa000, 0xffffc000,
  0xffff4000, 0xffff8000,
  0xfffe8000, 0xffff0000,
  0xfffd0000, 0xfffe0000,
  0xfffa0000, 0xfffc0000,
  0xfff40000, 0xfff80000,
  0xffe80000, 0xfff00000,
  0xffd00000, 0xffe00000,
  0xffa00000, 0xffc00000,
  0xff400000, 0xff800000,
  0xfe800000, 0xff000000,
  0xfd000000, 0xfe000000,
  0xfa000000, 0xfc000000,
  0xf4000000, 0xf8000000,
  0xe8000000, 0xf0000000,
  0xd0000000, 0xe0000000,
  0xa0000000, 0xc0000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0x7ffffffe, 0x7fffffff,
  0xfffffffc, 0xfffffffe,
  0xfffffff8, 0xfffffffc,
  0xfffffff0, 0xfffffff8,
  0xffffffe0, 0xfffffff0,
  0xffffffc0, 0xffffffe0,
  0xffffff80, 0xffffffc0,
  0xffffff00, 0xffffff80,
  0xfffffe00, 0xffffff00,
  0xfffffc00, 0xfffffe00,
  0xfffff800, 0xfffffc00,
  0xfffff000, 0xfffff800,
  0xffffe000, 0xfffff000,
  0xffffc000, 0xffffe000,
  0xffff8000, 0xffffc000,
  0xffff0000, 0xffff8000,
  0xfffe0000, 0xffff0000,
  0xfffc0000, 0xfffe0000,
  0xfff80000, 0xfffc0000,
  0xfff00000, 0xfff80000,
  0xffe00000, 0xfff00000,
  0xffc00000, 0xffe00000,
  0xff800000, 0xffc00000,
  0xff000000, 0xff800000,
  0xfe000000, 0xff000000,
  0xfc000000, 0xfe000000,
  0xf8000000, 0xfc000000,
  0xf0000000, 0xf8000000,
  0xe0000000, 0xf0000000,
  0xc0000000, 0xe0000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0x7fffffff, 0x80000000,
  0xfffffffe, 0x00000000,
  0xfffffffc, 0x00000000,
  0xfffffff8, 0x00000000,
  0xfffffff0, 0x00000000,
  0xffffffe0, 0x00000000,
  0xffffffc0, 0x00000000,
  0xffffff80, 0x00000000,
  0xffffff00, 0x00000000,
  0xfffffe00, 0x00000000,
  0xfffffc00, 0x00000000,
  0xfffff800, 0x00000000,
  0xfffff000, 0x00000000,
  0xffffe000, 0x00000000,
  0xffffc000, 0x00000000,
  0xffff8000, 0x00000000,
  0xffff0000, 0x00000000,
  0xfffe0000, 0x00000000,
  0xfffc0000, 0x00000000,
  0xfff80000, 0x00000000,
  0xfff00000, 0x00000000,
  0xffe00000, 0x00000000,
  0xffc00000, 0x00000000,
  0xff800000, 0x00000000,
  0xff000000, 0x00000000,
  0xfe000000, 0x00000000,
  0xfc000000, 0x00000000,
  0xf8000000, 0x00000000,
  0xf0000000, 0x00000000,
  0xe0000000, 0x00000000,
  0xc0000000, 0x00000000,
  0x80000000, 0x00000000,
  0x80000000, 0x80000001,
  0x00000000, 0x00000002,
  0x00000000, 0x00000004,
  0x00000000, 0x00000008,
  0x00000000, 0x00000010,
  0x00000000, 0x00000020,
  0x00000000, 0x00000040,
  0x00000000, 0x00000080,
  0x00000000, 0x00000100,
  0x00000000, 0x00000200,
  0x00000000, 0x00000400,
  0x00000000, 0x00000800,
  0x00000000, 0x00001000,
  0x00000000, 0x00002000,
  0x00000000, 0x00004000,
  0x00000000, 0x00008000,
  0x00000000, 0x00010000,
  0x00000000, 0x00020000,
  0x00000000, 0x00040000,
  0x00000000, 0x00080000,
  0x00000000, 0x00100000,
  0x00000000, 0x00200000,
  0x00000000, 0x00400000,
  0x00000000, 0x00800000,
  0x00000000, 0x01000000,
  0x00000000, 0x02000000,
  0x00000000, 0x04000000,
  0x00000000, 0x08000000,
  0x00000000, 0x10000000,
  0x00000000, 0x20000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
  0x80000001, 0xaaaaaaaa,
  0x00000002, 0x55555554,
  0x00000004, 0xaaaaaaa8,
  0x00000008, 0x55555550,
  0x00000010, 0xaaaaaaa0,
  0x00000020, 0x55555540,
  0x00000040, 0xaaaaaa80,
  0x00000080, 0x55555500,
  0x00000100, 0xaaaaaa00,
  0x00000200, 0x55555400,
  0x00000400, 0xaaaaa800,
  0x00000800, 0x55555000,
  0x00001000, 0xaaaaa000,
  0x00002000, 0x55554000,
  0x00004000, 0xaaaa8000,
  0x00008000, 0x55550000,
  0x00010000, 0xaaaa0000,
  0x00020000, 0x55540000,
  0x00040000, 0xaaa80000,
  0x00080000, 0x55500000,
  0x00100000, 0xaaa00000,
  0x00200000, 0x55400000,
  0x00400000, 0xaa800000,
  0x00800000, 0x55000000,
  0x01000000, 0xaa000000,
  0x02000000, 0x54000000,
  0x04000000, 0xa8000000,
  0x08000000, 0x50000000,
  0x10000000, 0xa0000000,
  0x20000000, 0x40000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0xaaaaaaaa, 0xcccccccc,
  0x55555554, 0x99999998,
  0xaaaaaaa8, 0x33333330,
  0x55555550, 0x66666660,
  0xaaaaaaa0, 0xccccccc0,
  0x55555540, 0x99999980,
  0xaaaaaa80, 0x33333300,
  0x55555500, 0x66666600,
  0xaaaaaa00, 0xcccccc00,
  0x55555400, 0x99999800,
  0xaaaaa800, 0x33333000,
  0x55555000, 0x66666000,
  0xaaaaa000, 0xccccc000,
  0x55554000, 0x99998000,
  0xaaaa8000, 0x33330000,
  0x55550000, 0x66660000,
  0xaaaa0000, 0xcccc0000,
  0x55540000, 0x99980000,
  0xaaa80000, 0x33300000,
  0x55500000, 0x66600000,
  0xaaa00000, 0xccc00000,
  0x55400000, 0x99800000,
  0xaa800000, 0x33000000,
  0x55000000, 0x66000000,
  0xaa000000, 0xcc000000,
  0x54000000, 0x98000000,
  0xa8000000, 0x30000000,
  0x50000000, 0x60000000,
  0xa0000000, 0xc0000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0x00000000, 0x00000000,
  0xcccccccc, 0xffff8000,
  0x99999998, 0xffff0000,
  0x33333330, 0xfffe0000,
  0x66666660, 0xfffc0000,
  0xccccccc0, 0xfff80000,
  0x99999980, 0xfff00000,
  0x33333300, 0xffe00000,
  0x66666600, 0xffc00000,
  0xcccccc00, 0xff800000,
  0x99999800, 0xff000000,
  0x33333000, 0xfe000000,
  0x66666000, 0xfc000000,
  0xccccc000, 0xf8000000,
  0x99998000, 0xf0000000,
  0x33330000, 0xe0000000,
  0x66660000, 0xc0000000,
  0xcccc0000, 0x80000000,
  0x99980000, 0x00000000,
  0x33300000, 0x00000000,
  0x66600000, 0x00000000,
  0xccc00000, 0x00000000,
  0x99800000, 0x00000000,
  0x33000000, 0x00000000,
  0x66000000, 0x00000000,
  0xcc000000, 0x00000000,
  0x98000000, 0x00000000,
  0x30000000, 0x00000000,
  0x60000000, 0x00000000,
  0xc0000000, 0x00000000,
  0x80000000, 0x00000000,
  0x00000000, 0x00000000,
  0x00000000, 0x00000000,
  0xffff8000, 0xffff8001,
  0xffff0000, 0xffff0002,
  0xfffe0000, 0xfffe0004,
  0xfffc0000, 0xfffc0008,
  0xfff80000, 0xfff80010,
  0xfff00000, 0xfff00020,
  0xffe00000, 0xffe00040,
  0xffc00000, 0xffc00080,
  0xff800000, 0xff800100,
  0xff000000, 0xff000200,
  0xfe000000, 0xfe000400,
  0xfc000000, 0xfc000800,
  0xf8000000, 0xf8001000,
  0xf0000000, 0xf0002000,
  0xe0000000, 0xe0004000,
  0xc0000000, 0xc0008000,
  0x80000000, 0x80010000,
  0x00000000, 0x00020000,
  0x00000000, 0x00040000,
  0x00000000, 0x00080000,
  0x00000000, 0x00100000,
  0x00000000, 0x00200000,
  0x00000000, 0x00400000,
  0x00000000, 0x00800000,
  0x00000000, 0x01000000,
  0x00000000, 0x02000000,
  0x00000000, 0x04000000,
  0x00000000, 0x08000000,
  0x00000000, 0x10000000,
  0x00000000, 0x20000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
  0xffff8001, 0xffff8002,
  0xffff0002, 0xffff0004,
  0xfffe0004, 0xfffe0008,
  0xfffc0008, 0xfffc0010,
  0xfff80010, 0xfff80020,
  0xfff00020, 0xfff00040,
  0xffe00040, 0xffe00080,
  0xffc00080, 0xffc00100,
  0xff800100, 0xff800200,
  0xff000200, 0xff000400,
  0xfe000400, 0xfe000800,
  0xfc000800, 0xfc001000,
  0xf8001000, 0xf8002000,
  0xf0002000, 0xf0004000,
  0xe0004000, 0xe0008000,
  0xc0008000, 0xc0010000,
  0x80010000, 0x80020000,
  0x00020000, 0x00040000,
  0x00040000, 0x00080000,
  0x00080000, 0x00100000,
  0x00100000, 0x00200000,
  0x00200000, 0x00400000,
  0x00400000, 0x00800000,
  0x00800000, 0x01000000,
  0x01000000, 0x02000000,
  0x02000000, 0x04000000,
  0x04000000, 0x08000000,
  0x08000000, 0x10000000,
  0x10000000, 0x20000000,
  0x20000000, 0x40000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0xffff8002, 0xffff8003,
  0xffff0004, 0xffff0006,
  0xfffe0008, 0xfffe000c,
  0xfffc0010, 0xfffc0018,
  0xfff80020, 0xfff80030,
  0xfff00040, 0xfff00060,
  0xffe00080, 0xffe000c0,
  0xffc00100, 0xffc00180,
  0xff800200, 0xff800300,
  0xff000400, 0xff000600,
  0xfe000800, 0xfe000c00,
  0xfc001000, 0xfc001800,
  0xf8002000, 0xf8003000,
  0xf0004000, 0xf0006000,
  0xe0008000, 0xe000c000,
  0xc0010000, 0xc0018000,
  0x80020000, 0x80030000,
  0x00040000, 0x00060000,
  0x00080000, 0x000c0000,
  0x00100000, 0x00180000,
  0x00200000, 0x00300000,
  0x00400000, 0x00600000,
  0x00800000, 0x00c00000,
  0x01000000, 0x01800000,
  0x02000000, 0x03000000,
  0x04000000, 0x06000000,
  0x08000000, 0x0c000000,
  0x10000000, 0x18000000,
  0x20000000, 0x30000000,
  0x40000000, 0x60000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0xffff8003, 0xffffff80,
  0xffff0006, 0xffffff00,
  0xfffe000c, 0xfffffe00,
  0xfffc0018, 0xfffffc00,
  0xfff80030, 0xfffff800,
  0xfff00060, 0xfffff000,
  0xffe000c0, 0xffffe000,
  0xffc00180, 0xffffc000,
  0xff800300, 0xffff8000,
  0xff000600, 0xffff0000,
  0xfe000c00, 0xfffe0000,
  0xfc001800, 0xfffc0000,
  0xf8003000, 0xfff80000,
  0xf0006000, 0xfff00000,
  0xe000c000, 0xffe00000,
  0xc0018000, 0xffc00000,
  0x80030000, 0xff800000,
  0x00060000, 0xff000000,
  0x000c0000, 0xfe000000,
  0x00180000, 0xfc000000,
  0x00300000, 0xf8000000,
  0x00600000, 0xf0000000,
  0x00c00000, 0xe0000000,
  0x01800000, 0xc0000000,
  0x03000000, 0x80000000,
  0x06000000, 0x00000000,
  0x0c000000, 0x00000000,
  0x18000000, 0x00000000,
  0x30000000, 0x00000000,
  0x60000000, 0x00000000,
  0xc0000000, 0x00000000,
  0x80000000, 0x00000000,
  0xffffff80, 0xffffff81,
  0xffffff00, 0xffffff02,
  0xfffffe00, 0xfffffe04,
  0xfffffc00, 0xfffffc08,
  0xfffff800, 0xfffff810,
  0xfffff000, 0xfffff020,
  0xffffe000, 0xffffe040,
  0xffffc000, 0xffffc080,
  0xffff8000, 0xffff8100,
  0xffff0000, 0xffff0200,
  0xfffe0000, 0xfffe0400,
  0xfffc0000, 0xfffc0800,
  0xfff80000, 0xfff81000,
  0xfff00000, 0xfff02000,
  0xffe00000, 0xffe04000,
  0xffc00000, 0xffc08000,
  0xff800000, 0xff810000,
  0xff000000, 0xff020000,
  0xfe000000, 0xfe040000,
  0xfc000000, 0xfc080000,
  0xf8000000, 0xf8100000,
  0xf0000000, 0xf0200000,
  0xe0000000, 0xe0400000,
  0xc0000000, 0xc0800000,
  0x80000000, 0x81000000,
  0x00000000, 0x02000000,
  0x00000000, 0x04000000,
  0x00000000, 0x08000000,
  0x00000000, 0x10000000,
  0x00000000, 0x20000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
  0xffffff81, 0xffffff82,
  0xffffff02, 0xffffff04,
  0xfffffe04, 0xfffffe08,
  0xfffffc08, 0xfffffc10,
  0xfffff810, 0xfffff820,
  0xfffff020, 0xfffff040,
  0xffffe040, 0xffffe080,
  0xffffc080, 0xffffc100,
  0xffff8100, 0xffff8200,
  0xffff0200, 0xffff0400,
  0xfffe0400, 0xfffe0800,
  0xfffc0800, 0xfffc1000,
  0xfff81000, 0xfff82000,
  0xfff02000, 0xfff04000,
  0xffe04000, 0xffe08000,
  0xffc08000, 0xffc10000,
  0xff810000, 0xff820000,
  0xff020000, 0xff040000,
  0xfe040000, 0xfe080000,
  0xfc080000, 0xfc100000,
  0xf8100000, 0xf8200000,
  0xf0200000, 0xf0400000,
  0xe0400000, 0xe0800000,
  0xc0800000, 0xc1000000,
  0x81000000, 0x82000000,
  0x02000000, 0x04000000,
  0x04000000, 0x08000000,
  0x08000000, 0x10000000,
  0x10000000, 0x20000000,
  0x20000000, 0x40000000,
  0x40000000, 0x80000000,
  0x80000000, 0x00000000,
  0xffffff82, 0xffffff83,
  0xffffff04, 0xffffff06,
  0xfffffe08, 0xfffffe0c,
  0xfffffc10, 0xfffffc18,
  0xfffff820, 0xfffff830,
  0xfffff040, 0xfffff060,
  0xffffe080, 0xffffe0c0,
  0xffffc100, 0xffffc180,
  0xffff8200, 0xffff8300,
  0xffff0400, 0xffff0600,
  0xfffe0800, 0xfffe0c00,
  0xfffc1000, 0xfffc1800,
  0xfff82000, 0xfff83000,
  0xfff04000, 0xfff06000,
  0xffe08000, 0xffe0c000,
  0xffc10000, 0xffc18000,
  0xff820000, 0xff830000,
  0xff040000, 0xff060000,
  0xfe080000, 0xfe0c0000,
  0xfc100000, 0xfc180000,
  0xf8200000, 0xf8300000,
  0xf0400000, 0xf0600000,
  0xe0800000, 0xe0c00000,
  0xc1000000, 0xc1800000,
  0x82000000, 0x83000000,
  0x04000000, 0x06000000,
  0x08000000, 0x0c000000,
  0x10000000, 0x18000000,
  0x20000000, 0x30000000,
  0x40000000, 0x60000000,
  0x80000000, 0xc0000000,
  0x00000000, 0x80000000,
  0xffffff83, 0xffffffe0,
  0xffffff06, 0xffffffc0,
  0xfffffe0c, 0xffffff80,
  0xfffffc18, 0xffffff00,
  0xfffff830, 0xfffffe00,
  0xfffff060, 0xfffffc00,
  0xffffe0c0, 0xfffff800,
  0xffffc180, 0xfffff000,
  0xffff8300, 0xffffe000,
  0xffff0600, 0xffffc000,
  0xfffe0c00, 0xffff8000,
  0xfffc1800, 0xffff0000,
  0xfff83000, 0xfffe0000,
  0xfff06000, 0xfffc0000,
  0xffe0c000, 0xfff80000,
  0xffc18000, 0xfff00000,
  0xff830000, 0xffe00000,
  0xff060000, 0xffc00000,
  0xfe0c0000, 0xff800000,
  0xfc180000, 0xff000000,
  0xf8300000, 0xfe000000,
  0xf0600000, 0xfc000000,
  0xe0c00000, 0xf8000000,
  0xc1800000, 0xf0000000,
  0x83000000, 0xe0000000,
  0x06000000, 0xc0000000,
  0x0c000000, 0x80000000,
  0x18000000, 0x00000000,
  0x30000000, 0x00000000,
  0x60000000, 0x00000000,
  0xc0000000, 0x00000000,
  0x80000000, 0x00000000,
  0xffffffe0, 0xfffffffd,
  0xffffffc0, 0xfffffffa,
  0xffffff80, 0xfffffff4,
  0xffffff00, 0xffffffe8,
  0xfffffe00, 0xffffffd0,
  0xfffffc00, 0xffffffa0,
  0xfffff800, 0xffffff40,
  0xfffff000, 0xfffffe80,
  0xffffe000, 0xfffffd00,
  0xffffc000, 0xfffffa00,
  0xffff8000, 0xfffff400,
  0xffff0000, 0xffffe800,
  0xfffe0000, 0xffffd000,
  0xfffc0000, 0xffffa000,
  0xfff80000, 0xffff4000,
  0xfff00000, 0xfffe8000,
  0xffe00000, 0xfffd0000,
  0xffc00000, 0xfffa0000,
  0xff800000, 0xfff40000,
  0xff000000, 0xffe80000,
  0xfe000000, 0xffd00000,
  0xfc000000, 0xffa00000,
  0xf8000000, 0xff400000,
  0xf0000000, 0xfe800000,
  0xe0000000, 0xfd000000,
  0xc0000000, 0xfa000000,
  0x80000000, 0xf4000000,
  0x00000000, 0xe8000000,
  0x00000000, 0xd0000000,
  0x00000000, 0xa0000000,
  0x00000000, 0x40000000,
  0x00000000, 0x80000000,
};
const unsigned kExpectedCount_NEON_shl_2S_2OPIMM = 992;

#endif  // VIXL_SIM_SHL_2S_2OPIMM_TRACE_AARCH64_H_
