# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class ServerConfigAboutInstance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'short_description': 'str',
        'description': 'str',
        'terms': 'str'
    }

    attribute_map = {
        'name': 'name',
        'short_description': 'shortDescription',
        'description': 'description',
        'terms': 'terms'
    }

    def __init__(self, name=None, short_description=None, description=None, terms=None, local_vars_configuration=None):  # noqa: E501
        """ServerConfigAboutInstance - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._short_description = None
        self._description = None
        self._terms = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if short_description is not None:
            self.short_description = short_description
        if description is not None:
            self.description = description
        if terms is not None:
            self.terms = terms

    @property
    def name(self):
        """Gets the name of this ServerConfigAboutInstance.  # noqa: E501


        :return: The name of this ServerConfigAboutInstance.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServerConfigAboutInstance.


        :param name: The name of this ServerConfigAboutInstance.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def short_description(self):
        """Gets the short_description of this ServerConfigAboutInstance.  # noqa: E501


        :return: The short_description of this ServerConfigAboutInstance.  # noqa: E501
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this ServerConfigAboutInstance.


        :param short_description: The short_description of this ServerConfigAboutInstance.  # noqa: E501
        :type short_description: str
        """

        self._short_description = short_description

    @property
    def description(self):
        """Gets the description of this ServerConfigAboutInstance.  # noqa: E501


        :return: The description of this ServerConfigAboutInstance.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ServerConfigAboutInstance.


        :param description: The description of this ServerConfigAboutInstance.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def terms(self):
        """Gets the terms of this ServerConfigAboutInstance.  # noqa: E501


        :return: The terms of this ServerConfigAboutInstance.  # noqa: E501
        :rtype: str
        """
        return self._terms

    @terms.setter
    def terms(self, terms):
        """Sets the terms of this ServerConfigAboutInstance.


        :param terms: The terms of this ServerConfigAboutInstance.  # noqa: E501
        :type terms: str
        """

        self._terms = terms

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerConfigAboutInstance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerConfigAboutInstance):
            return True

        return self.to_dict() != other.to_dict()
