/*****************************************************************************
 * pmwindow.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

/*
	exported by PhrozenSmoke from interface.c, to reduce monstrous size of 
	interface.c (can cause 'out of memory' errors while compiling)...
	all main PM Window UI creation functions
*/


#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "config.h"

#include "callbacks.h"
#include "interface.h"
#include "gyach.h"
#include "gyach_int.h"
#include "plugin_api.h"
#include "plugins.h"
#include "profname.h"
#include "pmwindow.h"
#include "pmnotebook.h"
#include "packet_handler.h"
#include "main.h"
#include "tuxvironments.h"
#include "util.h"

#include "theme_support.h"
#include "gy_config.h"
#include "gyachi_lib.h"
#include "spellcheck_plugin.h"


extern GtkWidget *yab_entry_list;
GList *encryption_list = NULL;
GdkColor tchat_online_color;


static char pmwinbuf[320];


/* PhrozenSmoke:  added some features here to save PMs to file */

int pm_capture_to_file( char *filename, GtkTextBuffer *mybuffer, GtkTextView *widget, GtkWidget  *mywindow ) {
	FILE *fp;
	int  length;
	GtkTextIter start;
	GtkTextIter end;
	gchar *ptr;
	gchar *capb2loc;
	char *lastfilename=NULL;
	FILE *lastfile=NULL;
	time_t time_llnow= time(NULL);

	/* Close possible old logs first */
	lastfilename=g_object_get_data(G_OBJECT(widget),"logfilename");
	lastfile=g_object_get_data(G_OBJECT(widget),"logfile");
	if (lastfile != NULL) {
		if (lastfilename != NULL) {
			snprintf(pmwinbuf,318, "  %s%s* %s : '%s' *\n%s%s", YAHOO_STYLE_ITALICON, "\033[#220099m", _("Stopped logging PM to file"), lastfilename, YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK);
			append_to_textbox_color( GTK_WIDGET(mywindow) ,GTK_WIDGET(widget), pmwinbuf );
		}

		fprintf( lastfile, "\n" );
		fflush(lastfile);
		fclose(lastfile);
		lastfile=NULL;
		g_object_set_data(G_OBJECT(widget),"logfile", lastfile);
	}


	if (!filename) {return 1;}
	if (lastfilename != NULL) {free(lastfilename);}
	g_object_set_data(G_OBJECT(widget),"logfilename", strdup(filename));

	fp = fopen( filename, "ab" );

	if ( ! fp )  {
		show_ok_dialog(_("Error opening file for saving."));
		return( 1 );
	}

	fprintf( fp, "\nGYachE Improved, version %s\n"
		 "Copyright 2007, Gregory D Hosler\n"
		 "Copyright 2006, Stefan Sikora and Zoltan Csala\n"
		 "Copyright (c) 2003-2005, Erica Andrews\n"
		 "%s\nLicense: GNU General Public License\n\n"
		 "INSTANT MESSAGE SESSION LOG\n", VERSION, GYACH_URL );
	fprintf( fp, "%s", ctime(&time_llnow ) );
	fprintf( fp, "\n_____________________\n\n" );
	fflush( fp );

	length = gtk_text_buffer_get_char_count( mybuffer );
	gtk_text_buffer_get_iter_at_offset(mybuffer, &start, 0 );
	gtk_text_buffer_get_iter_at_offset(mybuffer, &end, length );
	ptr = gtk_text_buffer_get_text(mybuffer, &start, &end, 0 );
	capb2loc=_b2loc(ptr);
	fwrite( capb2loc, 1, strlen(capb2loc), fp );
	g_free( ptr );
	fflush(fp);

	g_object_set_data(G_OBJECT(widget),"logfile", fp);
	snprintf(pmwinbuf,318, "  %s%s* %s : '%s' *\n%s%s", YAHOO_STYLE_ITALICON, "\033[#FFB8AFm", _("Logging PM to file"), filename, YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK);
	append_to_textbox_color( GTK_WIDGET(mywindow ),GTK_WIDGET(widget), pmwinbuf );

	return( 0 );
}

void pm_start_logging(char *myfile, GtkButton *button) {
	GtkTextBuffer *mybuff;
	GtkWidget *tmp_widget;
	GtkWidget *mywindow;
	tmp_widget=g_object_get_data(G_OBJECT(button),"pmstext");
	if (!tmp_widget) {return;}
	mybuff=g_object_get_data(G_OBJECT(tmp_widget),"textbuffer");
	if (!mybuff) {return;}
	mywindow=g_object_get_data(G_OBJECT(tmp_widget),"pmwindow");
	if (!mywindow) {return;}

	pm_capture_to_file( myfile, mybuff, GTK_TEXT_VIEW(tmp_widget), GTK_WIDGET(mywindow));
	gyachi_set_tooltip(GTK_WIDGET(button),_(" Stop Logging "));
}

char *pm_make_user_filename(char *who) {
	char fldate[100];
	time_t timell_now;
	struct tm *tmll_now;
	int length;
	char tmp_buf[300];

	snprintf(tmp_buf, 254, "%s/%s", logfile_directory, who?who:"default");

	gyachi_build_dir(tmp_buf, S_IRUSR | S_IWUSR | S_IXUSR);

	timell_now = time( NULL );
	tmll_now = localtime( &timell_now );
	if (! strftime(fldate, 99, logfile_template, tmll_now ) ) {
		sprintf(fldate,"%s","");
	}
	length=strlen(tmp_buf);
	snprintf(tmp_buf+length, 254-length-1, "/%s", fldate);
	return(strdup(tmp_buf));
}

void on_pmsavefile(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *filename=NULL;
	char *who=NULL;
	char *temp_name;

	tmp_widget=g_object_get_data(G_OBJECT(button),"pmstext");
	if (!tmp_widget) {return;}

	if (g_object_get_data(G_OBJECT(tmp_widget),"logfile") != NULL) {
		/* log file open, so close it and return */
		GtkTextBuffer *mybuff;
		GtkWidget *mywindow;
	     	mybuff=g_object_get_data(G_OBJECT(tmp_widget),"textbuffer");
	      	if (!mybuff) {return;}
	     	mywindow=g_object_get_data(G_OBJECT(button),"pmwindow");
	      	if (!mywindow) {return;}
		pm_capture_to_file( NULL, mybuff, GTK_TEXT_VIEW(tmp_widget), GTK_WIDGET(mywindow));
		gyachi_set_tooltip(GTK_WIDGET(button),_(" Start Logging "));
		return;
	}

	who=g_object_get_data(G_OBJECT(button),"who");
	if (who == NULL) {
	        temp_name=g_object_get_data(G_OBJECT(tmp_widget),"logfilename");
		if (temp_name) filename=strdup(temp_name);
	}
	if (filename == NULL) {
	        filename = pm_make_user_filename(who);
	}	

	pm_start_logging(filename, button);
	free(filename); filename=NULL;
}


/* END PhrozenSmoke:  added some features here to save PMs to file */


void activate_encryption(GtkWidget *button, gpointer user_data) {
	PM_SESSION *pms;
	GtkWidget *tuxwin;
	GtkWidget *tentry;
	char *stuff=NULL;

	tuxwin=g_object_get_data(G_OBJECT(button),"window");
	pms=g_object_get_data(G_OBJECT(button),"session");
	tentry=g_object_get_data(G_OBJECT(button),"entry");
	if (!pms) { if (tuxwin) {gtk_widget_destroy(tuxwin);} return;}
	if (!tentry) { if (tuxwin) {gtk_widget_destroy(tuxwin);} return;}

	stuff=strdup(gyachi_combobox_get_selected_item(tentry));

	if (!strcmp(stuff,_("[NONE]"))) {  /* turn encryption off */
		if (pms->encrypted_myway) {
			snprintf(pmwinbuf,300, "  %s%s* %s *\n%s%s",
				 YAHOO_STYLE_ITALICON,
				 "\033[#FFB8AFm",
				 _("Encrypted session stopped."),
				 YAHOO_STYLE_ITALICOFF,
				 YAHOO_COLOR_BLACK);
			append_to_textbox_color( pms->pm_window,pms->pm_text, pmwinbuf );
			set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pms->pm_window), PROFNAMESTR))));
			if (! pms->sms) {acknowledge_encryption(pms, 0);}
			reset_current_pm_profile_name();
			pms->encrypted_myway=0;
			pms->my_gpg_passphrase=-1;
			pms->their_gpg_passphrase=-1;
			free(stuff);
			if (tuxwin) {gtk_widget_destroy(tuxwin); focus_pm_entry(pms); }
			return;
		}

	}
	else {
		if ( (! enable_encryption) ||  (pms->sms)) {
			pms->encrypted_myway=0;
			pms->encryption_type=0;
			pms->my_gpg_passphrase=-1;
			pms->their_gpg_passphrase=-1;
			snprintf(pmwinbuf,300, "  %s%s* %s *\n%s%s",
				 YAHOO_STYLE_ITALICON,
				 "\033[#FFB8AFm",
				 _("Encryption is not currently enabled."),
				 YAHOO_STYLE_ITALICOFF,
				 YAHOO_COLOR_BLACK);
			append_to_textbox_color( pms->pm_window,pms->pm_text, pmwinbuf );
			free(stuff);
			if (tuxwin) {gtk_widget_destroy(tuxwin); focus_pm_entry(pms); }
			return;
		}
		else {
			int enctype=0;
			enctype=get_encryption_from_description(stuff);

			int apptest=0;

			if (pms->encryption_type != enctype) {
				snprintf(pmwinbuf,300, "  %s%s* %s '%s' *\n%s%s",
					 YAHOO_STYLE_ITALICON,
					 "\033[#FFB8AFm",
					 _("Requesting encrypted session..."),
					 stuff,
					 YAHOO_STYLE_ITALICOFF,
					 YAHOO_COLOR_BLACK);	
				append_to_textbox_color( pms->pm_window,pms->pm_text, pmwinbuf );
				set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pms->pm_window), PROFNAMESTR))));
				acknowledge_encryption(pms, enctype);

				/* It's important that we lock our profile identity in place
				   once we start using encryption stuff, otherwise 
				   encryption/decryption can fail for some algorithms */
				gtk_widget_set_sensitive(GTK_WIDGET(g_object_get_data(G_OBJECT(pms->pm_window),"profwidget" )), FALSE);

				reset_current_pm_profile_name();
				pms->encrypted_myway=1;
				pms->encryption_type=enctype;
				pms->my_gpg_passphrase=-1;
				pms->their_gpg_passphrase=-1;

				/* for testing */
				if (apptest) {
					/* *********  */
					/* 
					   char *appencstr=gyache_encrypt_message ("Shamis123Gone", "I feel you thought. Hmm, this is just another encryption test String. Testing for problems such as truncation, etc.: This is the Gyach Enhanced Encryption test string. I dont wanna grow up, I'm a toys r us kid. - PGP MESSAGE",
 pms->encryption_type);
					    printf("encryption success:  %s\n", appencstr); fflush(stdout);
					    printf("PM Decrypted: %s\n",
					           gyache_decrypt_message ("Shamis123Gone", appencstr, pms->encryption_type)	);
					    fflush(stdout);

					    if (capture_fp) {
						fprintf(capture_fp, "\n[%s] DEcrypt Msg [%s] : %s\n",
						        gyach_timestamp(), stuff, 
							gyache_decrypt_message ("Shamis123Gone", appencstr, pms->encryption_type));
						fflush(capture_fp);
					     }
					*/
				        /*  *********** */ 
				}
			}
			else {
				snprintf(pmwinbuf,300, "  %s%s* %s '%s' *\n%s%s",
					 YAHOO_STYLE_ITALICON,
					 "\033[#FFB8AFm",
					 _("The session is already using this encryption."),
					 stuff,
					 YAHOO_STYLE_ITALICOFF,
					 YAHOO_COLOR_BLACK);
				append_to_textbox_color( pms->pm_window,pms->pm_text, pmwinbuf );
			}
			if (tuxwin) {gtk_widget_destroy(tuxwin); focus_pm_entry(pms); }
			free(stuff);
			return;
		}
	}

	free(stuff);
	if (tuxwin) {gtk_widget_destroy(tuxwin); focus_pm_entry(pms); }
}



void create_encryption_list() {
	encryption_list = g_list_append( encryption_list, _("[NONE]"));

	if (encryption_type_available(ENC_TYPE_GPGME)) {
		encryption_list = g_list_append( encryption_list, ENC_STR_GPGME);
	}

	if (encryption_type_available(ENC_TYPE_BF_INTERNAL)) {
		encryption_list = g_list_append( encryption_list, ENC_STR_BF_INTERNAL);
	}

	if (encryption_type_available(ENC_TYPE_MCRYPT_BF) ) {

		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_BF);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_CAST128);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_CAST256); 
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_GOST);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_LOKI97);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_ARCFOUR);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_RC6);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_RIJNDAEL);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_SAFERPLUS);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_SERPENT);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_TD);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_TF);
		encryption_list = g_list_append( encryption_list, ENC_STR_MCRYPT_XTEA);


		/* Loki-97 and Cast-256 may have truncation issues, think its corrected */
	}
}


void create_encryption_window(PM_SESSION *pms, gpointer user_data) {
        GtkWidget *okbutton;
	GtkWidget *parent=user_data;

	if (!pms) {return;}
	if (!encryption_list) {create_encryption_list();}
	if (!encryption_list) {return;}

	okbutton=create_list_dialog(parent, _("Encryption"), _("Select An Encryption Method:"), NULL, encryption_list, FALSE, GTK_STOCK_DIALOG_AUTHENTICATION);

	g_object_set_data(G_OBJECT(okbutton), "session", pms);
	g_signal_connect(G_OBJECT (okbutton), "clicked",
			 G_CALLBACK(activate_encryption),
			 NULL);
}


void open_encryption_selection(GtkWidget *button, gpointer user_data) {
	PM_SESSION *pms;
	pms=g_object_get_data(G_OBJECT(button),"session");
	if (!pms) {return;}
	create_encryption_window(pms, user_data);
}


void acknowledge_encryption(PM_SESSION *pms, int encrypt_type) {
	if (encrypt_type==0) { /* turn encryption off */
		pms->encryption_type=0;
		pms->encrypted_myway=0;
		ymsg_encryption_notify( ymsg_sess, pms->pm_user, 0);
		return ;
	}

	if (encrypt_type==-1) { /* turn encryption off, its not available or not wanted */
		pms->encryption_type=0;
		pms->encrypted_myway=0;
		ymsg_encryption_notify( ymsg_sess, pms->pm_user, -1);
		return ;
	}

	if (!enable_encryption) {
		pms->encryption_type=0;
		pms->encrypted_myway=0;
		ymsg_encryption_notify( ymsg_sess, pms->pm_user, 0);
		return ;
	}

	if ( encryption_type_available(encrypt_type)) {
		pms->encryption_type=encrypt_type;
		pms->encrypted_myway=1;
		ymsg_encryption_notify( ymsg_sess, pms->pm_user, encrypt_type);
	} else {
		pms->encryption_type=0;
		pms->encrypted_myway=0;
		ymsg_encryption_notify( ymsg_sess, pms->pm_user, -1);
	}
	
}


void style_text_entry(GtkWidget *pms_entry) {
	PangoFontDescription *font_desc=NULL;
	int r=0,b=0,g=0;
	if (!strcmp(use_color,"custom")) {
		r=custom_color_red;
		g=custom_color_green;
		b=custom_color_blue;
	}
	if (!strcmp(use_color,"blue"))   {r = 0;    g = 0;    b = 0xd9;}
	if (!strcmp(use_color,"cyan"))   {r = 0;    g = 0xb8; b = 0xc8;}
	if (!strcmp(use_color,"gray"))   {r = 0x9a; g = 0xa0; b = 0xb3;}
	if (!strcmp(use_color,"green"))  {r = 0x4f; g = 0xbc; b = 0x6f;}
	if (!strcmp(use_color,"pink"))   {r = 0xff; g = 0xaf; b = 0xaf;}
	if (!strcmp(use_color,"purple")) {r = 0xb2; g = 0;    b = 0xba;}
	if (!strcmp(use_color,"yellow")) {r = 0xdd; g = 0xd9; b = 0x27;} 
	if (!strcmp(use_color,"orange")) {r = 0xe6; g = 0xb4; b = 0x2c;}
	if (!strcmp(use_color,"red"))    {r = 0xc8; g = 0x14; b = 0x47;}

	tchat_online_color.red   = r * ( 65535 / 255 );
	tchat_online_color.green = g * ( 65535 / 255 );
	tchat_online_color.blue  = b * ( 65535 / 255 );
	gtk_widget_modify_text(pms_entry, GTK_STATE_NORMAL, &tchat_online_color);
	font_desc = pango_font_description_from_string(font_name?font_name:"Sans 12");
	if (font_desc) {
		gtk_widget_modify_font(pms_entry,font_desc);
		pango_font_description_free(font_desc);
	}
}

void set_text_entry_styles() {
	GtkWidget *tmp_wid=NULL;
	GList *this_session = pm_list;
	PM_SESSION *pm_sess;

	tmp_wid=g_object_get_data(G_OBJECT(chat_window), "chat_entry");	
	if (tmp_wid) {style_text_entry(tmp_wid);}

	while( this_session ) {   /* any open PM sessions */
		tmp_wid=NULL;
		pm_sess = (PM_SESSION *)this_session->data;
		tmp_wid=g_object_get_data(G_OBJECT(pm_sess->pm_window), "pms_entry");	
		if (tmp_wid) {style_text_entry(tmp_wid);}
		this_session = g_list_next( this_session );
	}
	if (use_buddy_list_font) {
		PangoFontDescription *font_desc=NULL;
		font_desc = pango_font_description_from_string( display_font_name?display_font_name:"Sans 12" );
		if ( font_desc ) {
			if (bd_tree) {gtk_widget_modify_font  (bd_tree,font_desc);}
			if (chat_users) {gtk_widget_modify_font  (GTK_WIDGET(chat_users),font_desc);}
			if (yab_entry_list) {gtk_widget_modify_font  (yab_entry_list,font_desc);}
			pango_font_description_free(font_desc);
		}
	}
}


/*  exported from interface.c - PhrozenSmoke
    PM Windows in separate module to prevent MONSTROUS interface.c
*/


GtkWidget *get_display_image_bar(GtkWidget *widg, GtkWidget *parent) {
	GtkWidget *topbox, *vbox1, *hbox1, *hbox2, *hbox3;
	GtkWidget  *menubar1, *menu_head, *photo_menu, *photo_item;
	GtkWidget *bimage_me, *bimage_them, *bimage_butt;

	topbox = gtk_vbox_new (FALSE, 2);
	vbox1 = gtk_vbox_new (FALSE, 2);
	hbox1 = gtk_hbox_new (FALSE, 2);
	hbox2 = gtk_hbox_new (FALSE, 2);
	hbox3 = gtk_hbox_new (FALSE, 2);

	gtk_box_pack_start (GTK_BOX (topbox), hbox1, FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (topbox), gtk_label_new(""), TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (topbox), vbox1, FALSE, FALSE, 0);

	bimage_me=GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_DND) );
	bimage_butt=gtk_button_new();
	gyachi_set_tooltip(bimage_butt,_("Edit My Display Image..."));
	g_signal_connect(G_OBJECT (bimage_butt), "clicked",
			    G_CALLBACK(on_bimage_edit_my_photo),
			    parent);
	gtk_button_set_relief(GTK_BUTTON(bimage_butt), GTK_RELIEF_NONE);
	gtk_container_add(GTK_CONTAINER(bimage_butt), bimage_me);

	bimage_them=GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_DND) );
	gtk_box_pack_start (GTK_BOX (vbox1), gtk_hseparator_new(), FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (vbox1), bimage_them, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox1), gtk_hseparator_new(), FALSE, FALSE, 3);
	gtk_box_pack_start (GTK_BOX (vbox1), bimage_butt, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (topbox), gtk_label_new(" "), TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (hbox1), gtk_label_new(""), TRUE, TRUE, 0);
	menubar1 = gtk_menu_bar_new ();
	gtk_box_pack_start (GTK_BOX (hbox1), menubar1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox1), gtk_label_new(""), TRUE, TRUE, 0);
	menu_head = gtk_image_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (menubar1), menu_head);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_head), 
				      GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_ZOOM_IN, GTK_ICON_SIZE_MENU) ));
	photo_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_head), photo_menu);

	photo_item=gtk_menu_item_new_with_label(_("Show"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_show_cb),
			    vbox1);

	photo_item=gtk_menu_item_new_with_label(_("Hide"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_hide_cb),
			    vbox1);

	gtk_container_add (GTK_CONTAINER (photo_menu), gtk_menu_item_new());

	photo_item=gtk_menu_item_new_with_label(_("Small"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_update_size1),
			    widg);
	photo_item=gtk_menu_item_new_with_label(_("Medium"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_update_size2),
			    widg);
	photo_item=gtk_menu_item_new_with_label(_("Large"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_update_size3),
			    widg);

	gtk_box_pack_start (GTK_BOX (hbox2), gtk_label_new(""), TRUE, TRUE, 0);
	menubar1 = gtk_menu_bar_new ();
	gtk_box_pack_start (GTK_BOX (hbox2), menubar1, FALSE, FALSE, 0);
	menu_head = gtk_image_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (menubar1), menu_head);
	gtk_container_set_border_width (GTK_CONTAINER (menubar1), 0);
	gtk_container_set_border_width (GTK_CONTAINER (menu_head), 0);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_head),
				      GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_INDEX, GTK_ICON_SIZE_MENU) ));

	photo_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_head), photo_menu);

	photo_item=gtk_menu_item_new_with_label(_("View full-size avatar"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_view_avatar),
			    widg);
	photo_item=gtk_menu_item_new_with_label(_("View avatar animation"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_view_animation),
			    widg);

	gtk_box_pack_start (GTK_BOX (hbox3), gtk_label_new(""), TRUE, TRUE, 0);
	menubar1 = gtk_menu_bar_new ();
	gtk_box_pack_start (GTK_BOX (hbox3), menubar1, FALSE, FALSE, 0);
	menu_head = gtk_image_menu_item_new ();
	gtk_container_add (GTK_CONTAINER (menubar1), menu_head);
	gtk_container_set_border_width (GTK_CONTAINER (menubar1), 0);
	gtk_container_set_border_width (GTK_CONTAINER (menu_head), 0);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_head), 
				      GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_INDEX, GTK_ICON_SIZE_MENU) ));

	photo_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_head), photo_menu);

	photo_item=gtk_menu_item_new_with_label(_("Share my image"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_share),
			    widg);
	photo_item=gtk_menu_item_new_with_label(_("Don't share my image"));
	gtk_container_add (GTK_CONTAINER (photo_menu), photo_item);
	g_signal_connect(G_OBJECT (photo_item), "activate",
			    G_CALLBACK(on_bimage_share_off),
			    widg);

	g_object_set_data(G_OBJECT(topbox), "panel",       vbox1 );
	g_object_set_data(G_OBJECT(topbox), "bimage_me",   bimage_me );
	g_object_set_data(G_OBJECT(topbox), "bimage_them", bimage_them );
	g_object_set_data(G_OBJECT(topbox), "bimage_butt", bimage_butt );
	gtk_widget_show_all(topbox);
	return topbox;
}



GtkWidget *create_pm_session (char *forwho)
{
  GtkWidget *pm_session;
  GtkWidget *vbox13;
  GtkWidget *scrolledwindow8;
  GtkWidget *pms_text;
  GtkWidget *hbox14;
  GtkWidget *pms_entry;
  GtkWidget *pms_send;
  GtkWidget *pms_clear;
  GtkWidget *hbox13;
  GtkWidget *hbox_main;
  GtkWidget *pms_profile;
  GtkWidget *pms_close;
  GtkWidget *pms_ignore;
  GtkWidget *buzz_user;
  GtkWidget *voice_chat;
  GtkWidget *send_user;
  GtkWidget *tuxviron;
  GtkWidget *encbutton;
  GtkWidget *photoshare;
  GtkWidget *save_user;
  GtkWidget *pms_status;
  GtkWidget *smile_button;
  GtkWidget *profwidget, *topbox;
  GtkWidget *pm_toolbar;
  GtkWidget *pm_aud, *ptlabel;
  GtkWidget *pmst_menu, *webcam_menu, *inv_conf, *startcam, *yphoto, *yphotoshare, *dlmanager;
  GtkWidget *sendcam, *menubar1, *menu_head, *start_conf, *yab, *fadd1, *fadd2; 
  GtkWidget *hpaned1=NULL;
  GList *focus_chain = NULL;
  GYACHI_NOTEBOOK_INTERFACE *gy_notebook;

  /* pm_session = gtk_window_new (GTK_WINDOW_TOPLEVEL); */
  pm_session = gtk_vpaned_new();

  gy_notebook = pm_notebook_add_window(pm_session, forwho);

  /*
   * gtk_window_set_wmclass (GTK_WINDOW (pm_session), "gyachEPM", "GYachI");
   * gtk_window_set_title (GTK_WINDOW (pm_session), _("Yahoo! Private Message"));
   * gtk_window_set_default_size (GTK_WINDOW (pm_session), 512, 365);
   */

  g_object_set_data(G_OBJECT(pm_session), "pm_session", pm_session);

  hbox_main = gtk_hpaned_new();
  g_object_set_data(G_OBJECT(pm_session),"hbox_main" ,hbox_main );
  vbox13 = gtk_vbox_new (FALSE, 0);

  topbox = gtk_hbox_new (FALSE, 0);
  if (pmb_toolbar1) {gtk_box_pack_start (GTK_BOX (vbox13), topbox, FALSE, FALSE, 2);}
  profwidget=get_profile_name_component(1);
  gtk_box_pack_start (GTK_BOX (topbox), profwidget, TRUE, TRUE, 0);
  g_object_set_data(G_OBJECT(pm_session),PROFNAMESTR , g_object_get_data(G_OBJECT(profwidget), PROFNAMESTR));
  g_object_set_data(G_OBJECT(pm_session),"profwidget", profwidget );
  g_object_set_data(G_OBJECT(pm_session),"profcombo",  g_object_get_data(G_OBJECT(profwidget), "profcombo"));
 
  ptlabel=g_object_get_data(G_OBJECT(profwidget), "label");
  if (ptlabel) {gtk_label_set_text(GTK_LABEL(ptlabel), _("From:") );}


  gtk_box_pack_start (GTK_BOX (topbox), gtk_label_new(" "), FALSE, FALSE, 0);
  pm_toolbar= gtk_hbox_new(TRUE, 0);
  g_object_set_data(G_OBJECT(pm_session), "with_fader_button", pm_toolbar);
  g_object_set_data(G_OBJECT(pm_session), "chat_toolbar",      pm_toolbar );
  gtk_box_pack_start (GTK_BOX(topbox), pm_toolbar, FALSE, FALSE, 3);

  gtk_widget_realize(pm_session);

  gtk_container_set_border_width(GTK_CONTAINER (pm_toolbar), 1);
  gtk_widget_show(pm_toolbar);
  build_toolbar( pm_session);

  hbox13 = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox13), 1);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_main), 2);
  if (pmb_toolbar2) {gtk_box_pack_start (GTK_BOX (vbox13), hbox13, FALSE, FALSE, 0); }
  gtk_paned_pack1(GTK_PANED(hbox_main), vbox13, TRUE, TRUE);

  if (pm_window_style==1) {
  	hpaned1 = gtk_vpaned_new ();
	gtk_box_pack_start (GTK_BOX (vbox13), hpaned1, TRUE, TRUE, 0);	 
  }

  scrolledwindow8 = gtk_scrolled_window_new (NULL, NULL);
  g_object_set_data(G_OBJECT(pm_session), "scrolledwindow8", scrolledwindow8);

  if (pm_window_style==1) {
  	gtk_paned_pack1 (GTK_PANED (hpaned1), scrolledwindow8, TRUE, TRUE);
  }
  else {
    gtk_box_pack_start (GTK_BOX (vbox13), scrolledwindow8, TRUE, TRUE, 0);
  }
  gtk_widget_show (scrolledwindow8);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow8), 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow8), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow8), GTK_SHADOW_ETCHED_OUT);

  pms_text = gtk_text_view_new ();
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW( pms_text ), 5);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW( pms_text ), 5);
  GTK_WIDGET_UNSET_FLAGS(pms_text, GTK_CAN_FOCUS);
  gtk_widget_set_events(pms_text, (GDK_POINTER_MOTION_MASK|GDK_POINTER_MOTION_HINT_MASK));

  g_object_set_data(G_OBJECT(pm_session), "pms_text", pms_text); 
  gtk_container_add (GTK_CONTAINER (scrolledwindow8), pms_text);
  gtk_widget_show (pms_text);


  /* hold on to text buffer for smileys : PhrozenSmoke */

  g_object_set_data(G_OBJECT(pms_text), "textbuffer", gtk_text_view_get_buffer( GTK_TEXT_VIEW(pms_text)));
  g_object_set_data(G_OBJECT(pms_text), "pmwindow", pm_session);
  g_object_set_data(G_OBJECT(GTK_TEXT_VIEW(pms_text)->vadjustment), "pmwindow", pm_session);

  /* Needed for TuxVironment redrawing events, do not remove */
  g_signal_connect(G_OBJECT(GTK_TEXT_VIEW(pms_text)->vadjustment), "value-changed", G_CALLBACK(tuxviron_redraw_notify_event),NULL);
  g_signal_connect(G_OBJECT(pms_text), "configure-event", G_CALLBACK(tuxviron_redraw_notify_event), NULL);

  hbox14 = gtk_hbox_new (FALSE, 0);

  if (pm_window_style==1) {
  	 gtk_paned_pack2 (GTK_PANED (hpaned1), hbox14, FALSE, TRUE);
  }
  else {
	gtk_box_pack_start (GTK_BOX (vbox13), hbox14, FALSE, TRUE, 0);
  }
  
  gtk_container_set_border_width (GTK_CONTAINER (hbox14), 1);

  /* smiley button */
  smile_button=get_smiley_button("smicon",0);
  	g_signal_connect(G_OBJECT(smile_button), "clicked",
                      G_CALLBACK(show_smiley_window_pm), NULL);	
  gyachi_set_tooltip(smile_button,_("Smileys"));
  gtk_button_set_relief(GTK_BUTTON(smile_button), GTK_RELIEF_NONE);

  if (pmb_smileys) {
    gtk_box_pack_start (GTK_BOX (hbox14), smile_button, FALSE, FALSE, 1);
  }


  pm_aud=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(pm_aud), gtk_image_new_from_stock(GYACHI_PM_AUDIBLE, GTK_ICON_SIZE_LARGE_TOOLBAR) );
  gtk_container_set_border_width(GTK_CONTAINER(pm_aud), 1);
  gtk_button_set_relief(GTK_BUTTON(pm_aud), GTK_RELIEF_NONE);
  gyachi_set_tooltip(pm_aud,_(" Audibles "));

  switch (messy_ver) {
  case YMSG_VER_11:
	break;

  case YMSG_VER_13:
  case YMSG_VER_15:
  case YMSG_VER_16:
	if (pmb_audibles && enable_audibles) {
		gtk_box_pack_start (GTK_BOX (hbox14), pm_aud, FALSE, FALSE, 1);
	}
	break;
  }

  if (pm_window_style==1) {
        GtkTextBuffer *tbe=NULL;
	GtkTextIter	end_iter;
	scrolledwindow8 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow8), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow8), GTK_SHADOW_IN);
	pms_entry = gtk_text_view_new ();
	if (gtk_spellcheck) {
	  spellcheck_activate(GTK_TEXT_VIEW(pms_entry), TRUE, gy_notebook->window);
	}

	gtk_text_view_set_left_margin (GTK_TEXT_VIEW(pms_entry ), 5);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW( pms_entry), 5);
	g_object_set_data(G_OBJECT(pm_session), "pms_entry", pms_entry);
	gtk_container_add (GTK_CONTAINER (scrolledwindow8), pms_entry);
	gtk_box_pack_start (GTK_BOX (hbox14), scrolledwindow8, TRUE, TRUE, 0);

	tbe=gtk_text_view_get_buffer(GTK_TEXT_VIEW(pms_entry));
	g_object_set_data(G_OBJECT(pms_entry), "textbuffer", tbe);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(pms_entry), GTK_WRAP_WORD );
	gtk_text_buffer_get_end_iter( tbe, &end_iter );
	gtk_text_buffer_create_mark( tbe, "end_mark", &end_iter, 0 );
  }
  else {
        pms_entry = gtk_entry_new ();
	gtk_entry_set_max_length(GTK_ENTRY(pms_entry),425);
	g_object_set_data(G_OBJECT(pms_entry), "is_gtk_entry", "1");
	g_object_set_data(G_OBJECT(pm_session), "pms_entry", pms_entry);
	gtk_box_pack_start (GTK_BOX (hbox14), pms_entry, TRUE, TRUE, 0);
   }


  g_object_set_data(G_OBJECT(pms_entry), PROFNAMESTR, g_object_get_data(G_OBJECT(profwidget), PROFNAMESTR));
  g_object_set_data(G_OBJECT(smile_button), "entry", pms_entry);
  g_object_set_data(G_OBJECT(smile_button), "pmwindow", pm_session);
  style_text_entry(pms_entry);

  pms_send=get_stocki_button(GTK_STOCK_OK, _("Send"), GTK_ICON_SIZE_SMALL_TOOLBAR);
  if (pmb_send_erase) {
    gtk_box_pack_start (GTK_BOX (hbox14), pms_send, FALSE, FALSE, 1);
  }

  pms_clear=get_stocki_button(GTK_STOCK_CLEAR, _("Clear"), GTK_ICON_SIZE_LARGE_TOOLBAR);
  if (pmb_send_erase) {
    gtk_box_pack_start (GTK_BOX (hbox14), pms_clear, FALSE, FALSE, 1);
  }


  pms_profile=get_stocki_button(GTK_STOCK_DIALOG_INFO,_("Profile"), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), pms_profile, FALSE, FALSE, 0);
  g_object_set_data(G_OBJECT(pm_session), "pms_profile", pms_profile);

  /* added: PhrozenSmoke - button for 'Buzz' feature */
  buzz_user=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(buzz_user), gtk_image_new_from_stock(GYACHI_PM_BUZZ, GTK_ICON_SIZE_MENU));
  gtk_container_set_border_width(GTK_CONTAINER(buzz_user), 0);
  gtk_button_set_relief(GTK_BUTTON(buzz_user), GTK_RELIEF_NONE);
  gyachi_set_tooltip(buzz_user,_(" Buzz "));
  gtk_box_pack_start (GTK_BOX (hbox13), buzz_user, FALSE, FALSE, 0);

  /* added: PhrozenSmoke - button for 'voice chat' feature */
  voice_chat=get_stocki_button(GTK_STOCK_EXECUTE, _(" Voice Chat "), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), voice_chat, FALSE, FALSE, 0);

  tuxviron=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(tuxviron), gtk_image_new_from_stock(GYACHI_PM_TUX, GTK_ICON_SIZE_MENU));
  gtk_container_set_border_width(GTK_CONTAINER(tuxviron), 0);
  gtk_button_set_relief(GTK_BUTTON(tuxviron), GTK_RELIEF_NONE);
  gyachi_set_tooltip(tuxviron,_(" TUXVironment... "));
  gtk_box_pack_start (GTK_BOX (hbox13), tuxviron, FALSE, FALSE, 0);

  encbutton=get_stocki_button(GTK_STOCK_DIALOG_AUTHENTICATION, _("Encryption..."), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), encbutton, FALSE, FALSE, 0);

  /* added: PhrozenSmoke - button for 'Send File..' feature */
  send_user=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(send_user), gtk_image_new_from_stock(GYACHI_PM_FILE, GTK_ICON_SIZE_MENU));
  gtk_container_set_border_width(GTK_CONTAINER(send_user), 0);
  gtk_button_set_relief(GTK_BUTTON(send_user), GTK_RELIEF_NONE);
  gyachi_set_tooltip(send_user,_(" Send File... "));
  gtk_box_pack_start (GTK_BOX (hbox13), send_user, FALSE, FALSE, 0);

  photoshare = get_stocki_button(GYACHI_PHOTOSHARE, _("Share Photos..."), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), photoshare, FALSE, FALSE, 0);

  save_user=get_stocki_button(GTK_STOCK_SAVE, _(" Save"), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), save_user, FALSE, FALSE, 0);
  g_object_set_data(G_OBJECT(save_user), "pmstext", pms_text);
  g_object_set_data(G_OBJECT(save_user), "pmwindow", pm_session);


  /* Sub-menu */

  menubar1 = gtk_menu_bar_new ();
  gtk_box_pack_start (GTK_BOX (hbox13), menubar1, FALSE, FALSE, 0);
  menu_head = gtk_image_menu_item_new ();
  gtk_container_add (GTK_CONTAINER (menubar1), menu_head);
  gtk_container_set_border_width (GTK_CONTAINER (menubar1), 0);
  gtk_container_set_border_width (GTK_CONTAINER (menu_head), 0);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_head), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_INDEX, GTK_ICON_SIZE_MENU) ));

  pmst_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_head), pmst_menu);

  webcam_menu = gtk_image_menu_item_new_with_label (_(" View Webcam... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(webcam_menu), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_ZOOM_100, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu), webcam_menu);
  g_object_set_data(G_OBJECT(pm_session), "pms_menu2", webcam_menu);

  startcam = gtk_image_menu_item_new_with_label (_(" Start My Webcam... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(startcam), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_YES, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu), startcam);

  sendcam = gtk_image_menu_item_new_with_label (_(" Send Webcam Invitation... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(sendcam), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DND, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu), sendcam);
  g_object_set_data(G_OBJECT(pm_session), "pms_menu1", sendcam);


  /* separator */
  gtk_container_add (GTK_CONTAINER (pmst_menu), gtk_menu_item_new ());

  inv_conf = gtk_image_menu_item_new_with_label (_("Invite User to Room or Conference..."));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(inv_conf ), 
				GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_CONVERT, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),inv_conf);

  start_conf = gtk_image_menu_item_new_with_label (_("Start A Conference"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(start_conf ), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DND, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),start_conf);

  /* separator */
  gtk_container_add (GTK_CONTAINER (pmst_menu), gtk_menu_item_new ());

  yab = gtk_image_menu_item_new_with_label (_("Edit Contact Information..."));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(yab ), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_FIND_AND_REPLACE, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),yab);
  g_object_set_data(G_OBJECT(pm_session), "yab", yab);

  /* separator */
  gtk_container_add (GTK_CONTAINER (pmst_menu), gtk_menu_item_new ());

  if (plugins_yphotos_loaded()) {
	// Not sure if this feature is still used within yahoo ...
	yphoto = gtk_image_menu_item_new_with_label (_("Share a photo album..."));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(yphoto ), 
				      GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU) ));
	gtk_container_add (GTK_CONTAINER (pmst_menu),yphoto);

	/* separator */
	gtk_container_add (GTK_CONTAINER (pmst_menu), gtk_menu_item_new ());
  }

  yphotoshare = gtk_image_menu_item_new_with_label (_("Share photos with this contact"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(yphotoshare), 
	GTK_WIDGET(gtk_image_new_from_stock(GYACHI_PHOTOSHARE, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),yphotoshare);

  dlmanager = gtk_image_menu_item_new_with_label (_("Download Manager"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(dlmanager), 
	GTK_WIDGET(gtk_image_new_from_stock(GYACHI_PM_FILE, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),dlmanager);

  /* separator */
  gtk_container_add (GTK_CONTAINER (pmst_menu), gtk_menu_item_new ());

  fadd1 = gtk_image_menu_item_new_with_label (_(" Add To Friends "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(fadd1 ), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_ADD, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),fadd1);
  g_object_set_data(G_OBJECT(pm_session), "fadd1", fadd1);

  fadd2 = gtk_image_menu_item_new_with_label (_(" Add As Temporary Friend "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(fadd2 ), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_ADD, GTK_ICON_SIZE_MENU) ));
  gtk_container_add (GTK_CONTAINER (pmst_menu),fadd2);
  g_object_set_data(G_OBJECT(pm_session), "fadd2", fadd2);

  g_signal_connect(G_OBJECT(fadd1), "activate",
                      G_CALLBACK(on_pms_add_friend),
		      gy_notebook->window);
  g_signal_connect(G_OBJECT(fadd2), "activate",
                      G_CALLBACK(on_pms_add_tempfriend),
		      gy_notebook->window);
  g_signal_connect(G_OBJECT(yab), "activate",
                      G_CALLBACK(on_pms_get_yab),
                      pm_session);
  if (plugins_yphotos_loaded()) {
	g_signal_connect(G_OBJECT(yphoto), "activate",
			 G_CALLBACK(on_pms_yphoto_start),
			 pm_session);
  }
  g_signal_connect(G_OBJECT(yphotoshare), "activate",
                      G_CALLBACK(on_pms_yphotoshare_start),
                      pm_session);
  g_signal_connect(G_OBJECT(dlmanager), "activate",
                      G_CALLBACK(on_pms_dlmanager_start),
                      pm_session);

  g_signal_connect(G_OBJECT(start_conf), "activate",
                      G_CALLBACK(on_start_conference),
                      gy_notebook->window);
  g_signal_connect(G_OBJECT(webcam_menu), "activate",
                      G_CALLBACK(on_pms_viewcam),
		      gy_notebook->window);
  g_signal_connect(G_OBJECT(inv_conf), "activate",
                      G_CALLBACK(on_invite_to_conf),
                      gy_notebook->window);
  g_signal_connect(G_OBJECT(startcam), "activate",
                      G_CALLBACK(on_startmycam),
                      NULL);
  g_signal_connect(G_OBJECT(sendcam), "activate",
                      G_CALLBACK(on_pms_sendcaminvite),
		      gy_notebook->window);

  gtk_box_pack_start (GTK_BOX (hbox13), gtk_label_new("    "), FALSE, FALSE, 0);

  pms_ignore=get_stocki_button(GTK_STOCK_DIALOG_ERROR,_("Ignore"), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), pms_ignore, FALSE, FALSE, 0);

  pms_status=gtk_label_new("                       ");  /* holds typing status */
  gtk_box_pack_start (GTK_BOX (hbox13), pms_status, TRUE, TRUE, 1);

  pms_close=get_stocki_button(GTK_STOCK_CLOSE,_("Close"), GTK_ICON_SIZE_MENU);
  gtk_box_pack_start (GTK_BOX (hbox13), pms_close, FALSE, FALSE, 0);

  g_object_set_data(G_OBJECT(pm_session), "pms_status",  pms_status);
  g_object_set_data(G_OBJECT(pm_session), "pms_send",    pms_send);
  g_object_set_data(G_OBJECT(pm_session), "pms_clear",   pms_clear);
  g_object_set_data(G_OBJECT(pm_session), "pms_profile", pms_profile);
  g_object_set_data(G_OBJECT(pm_session), "buzz_user",   buzz_user);
  g_object_set_data(G_OBJECT(pm_session), "voice_chat",  voice_chat);
  g_object_set_data(G_OBJECT(pm_session), "tuxviron",    tuxviron);
  g_object_set_data(G_OBJECT(pm_session), "encbutton",   encbutton);
  g_object_set_data(G_OBJECT(pm_session), "send_user",   send_user);
  g_object_set_data(G_OBJECT(pm_session), "save_user",   save_user);
  g_object_set_data(G_OBJECT(pm_session), "pms_ignore",  pms_ignore);
  g_object_set_data(G_OBJECT(pm_session), "pms_close",   pms_close);
  g_object_set_data(G_OBJECT(pm_session), "pm_aud",      pm_aud);

  g_signal_connect(G_OBJECT(pms_text), "button-press-event",
                      G_CALLBACK(on_pms_text_button_press_event),
                      NULL);

  /* setup the callback for url highlighting */
  g_signal_connect_after(G_OBJECT(pms_text),  "motion-notify-event",
		      G_CALLBACK(chat_motion_notify),
		      NULL);


  if (pm_window_style != 1) {
        g_signal_connect(G_OBJECT(pms_entry), "activate",
			    G_CALLBACK(on_pms_entry_activate),
			    NULL);
  }

  g_signal_connect(G_OBJECT(pms_entry), "key-press-event",
                      G_CALLBACK(on_pms_entry_key_press_event),
                      NULL);
  g_signal_connect(G_OBJECT(pms_send), "clicked",
                      G_CALLBACK(on_pms_send_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(pms_clear), "clicked",
                      G_CALLBACK(on_pms_clear_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(pms_profile), "clicked",
                      G_CALLBACK(on_pms_profile_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(send_user), "clicked",
                      G_CALLBACK(on_pms_sendfile_clicked),
                      gy_notebook->window);
  g_signal_connect(G_OBJECT(pms_close), "clicked",
                      G_CALLBACK(on_pms_close_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(pms_ignore), "clicked",
                      G_CALLBACK(on_pms_ignore_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(buzz_user), "clicked",
                      G_CALLBACK(on_pms_buzz_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(voice_chat), "clicked",
                      G_CALLBACK(on_activate_voice_conf),
                      NULL);
  g_signal_connect(G_OBJECT(save_user), "clicked",
                      G_CALLBACK(on_pmsavefile),
                      NULL);
  g_signal_connect(G_OBJECT(tuxviron), "clicked",
                      G_CALLBACK(open_tuxvironment_selection),
                      gy_notebook->window);
  g_signal_connect(G_OBJECT(encbutton), "clicked",
                      G_CALLBACK(open_encryption_selection),
                      gy_notebook->window);
  g_signal_connect(G_OBJECT(photoshare), "clicked",
                      G_CALLBACK(on_pms_yphotoshare_start),
                      pm_session);
  g_signal_connect(G_OBJECT(pm_aud), "clicked",
                      G_CALLBACK(on_open_audible_window),
                      NULL);

  if (show_bimages) { 
	GtkWidget *vbox_extra, *bim_box;
	vbox_extra=gtk_hbox_new (FALSE, 0);
	bim_box=get_display_image_bar(pms_entry, gy_notebook->window);
	gtk_container_set_border_width (GTK_CONTAINER (bim_box), 3);
	gtk_box_pack_start (GTK_BOX (vbox_extra), hbox_main, TRUE, TRUE, 1);
	gtk_box_pack_start (GTK_BOX (vbox_extra), bim_box, FALSE, FALSE, 1);
  	gtk_paned_pack2(GTK_PANED(pm_session), vbox_extra, TRUE, TRUE);
  	g_object_set_data(G_OBJECT(pm_session),"panel" ,g_object_get_data(G_OBJECT(bim_box), "panel") );
  	g_object_set_data(G_OBJECT(pm_session),"bimage_me" ,g_object_get_data(G_OBJECT(bim_box), "bimage_me") );
  	g_object_set_data(G_OBJECT(pm_session),"bimage_them" ,g_object_get_data(G_OBJECT(bim_box), "bimage_them") );
 	g_object_set_data(G_OBJECT(g_object_get_data(G_OBJECT(bim_box), "bimage_butt")),"textfocus" , pms_entry);
 	g_object_set_data(G_OBJECT(g_object_get_data(G_OBJECT(bim_box), "panel")), "gy_notebook" , gy_notebook); /* for show/hide callbacks */
  }
  else {
  	gtk_paned_pack2(GTK_PANED(pm_session), hbox_main, TRUE, TRUE);
  }

  /*
   * the focus order:
   * text input -> send -> smiley, clear, audibles ->
   * top row profile -> then box [bold, italics, underline, color, effects, font] ->
   * 2nd row left to right [profile, buzz, voice chat, tux, encrypt, send file, join chat, save, pulldown menu,
   *                        ignore, and then close]
   */

  focus_chain = g_list_prepend(focus_chain, hbox13);
  focus_chain = g_list_prepend(focus_chain, topbox);
  focus_chain = g_list_prepend(focus_chain, pm_aud);
  focus_chain = g_list_prepend(focus_chain, pms_clear);
  focus_chain = g_list_prepend(focus_chain, smile_button);
  focus_chain = g_list_prepend(focus_chain, pms_send);
  focus_chain = g_list_prepend(focus_chain, pms_entry);
  gtk_container_set_focus_chain(GTK_CONTAINER(pm_session), focus_chain);
  g_list_free(focus_chain);

  gtk_widget_show_all(pm_session);
  return pm_session;
}

GtkWidget* create_pm_window(GtkWidget *parent, char *some_sn)
{
  GtkWidget *pm_window;
  GtkWidget *vbox4;
  GtkWidget *hbox4;
  GtkWidget *pm_user_label;
  GtkWidget *pm_user;
  GtkWidget *pm_entry;
  GtkWidget *hbox5;
  GtkWidget *pm_send;
  GtkWidget *pm_cancel;
  GtkWidget *profwidget;

  pm_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_object_set_data(G_OBJECT(pm_window), "pm_window", pm_window);
  /* gtk_widget_set_size_request(pm_window, 310, 80); */
  gtk_window_set_modal(GTK_WINDOW(pm_window), TRUE);  /* needs to be true : PhrozenSmoke */
  gtk_window_set_title (GTK_WINDOW (pm_window), _("Yahoo! Instant Message"));
  gtk_window_set_default_size (GTK_WINDOW (pm_window), 390, -1);
  gtk_window_set_position (GTK_WINDOW (pm_window), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_transient_for(GTK_WINDOW(pm_window), GTK_WINDOW(parent));
  gtk_window_set_destroy_with_parent(GTK_WINDOW(pm_window), TRUE);

  vbox4 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (pm_window), vbox4);
  gtk_container_set_border_width (GTK_CONTAINER (vbox4), 5);

  gtk_box_pack_start (GTK_BOX (vbox4),
		      GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_DND)),
		      FALSE, FALSE , 3);
  gtk_widget_show_all (vbox4);

  profwidget=get_profile_name_component(1);
  gtk_box_pack_start (GTK_BOX (vbox4), profwidget, FALSE, FALSE, 2);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox4, FALSE, FALSE, 0);
  gtk_widget_show (hbox4);

  pm_user_label = gtk_label_new (_("Username: "));
  g_object_set_data(G_OBJECT(pm_window), "pm_user_label", pm_user_label);
  gtk_box_pack_start (GTK_BOX (hbox4), pm_user_label, FALSE, FALSE, 0);
  gtk_widget_show (pm_user_label);
  gtk_misc_set_padding (GTK_MISC (pm_user_label), 5, 0);

  pm_user = gtk_entry_new ();
  gtk_entry_set_max_length(GTK_ENTRY(pm_user),64);
  g_object_set_data(G_OBJECT(pm_window), "pm_user", pm_user);
  gtk_box_pack_start (GTK_BOX (hbox4), pm_user, TRUE, TRUE, 0);
  if (some_sn) gtk_entry_set_text( GTK_ENTRY(pm_user), some_sn);
  gtk_widget_show (pm_user);

  pm_entry = gtk_entry_new ();
  style_text_entry(pm_entry);
  gtk_entry_set_max_length(GTK_ENTRY(pm_entry),425);
  g_object_set_data(G_OBJECT(pm_window), "pm_entry", pm_entry);
  gtk_box_pack_start (GTK_BOX (vbox4), pm_entry, FALSE, FALSE, 0);
  gtk_widget_show (pm_entry);

  g_object_set_data(G_OBJECT(pm_entry), PROFNAMESTR, g_object_get_data(G_OBJECT(profwidget), PROFNAMESTR));

  hbox5 = gtk_hbox_new (TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox5, FALSE, FALSE, 0);
  gtk_widget_show (hbox5);

  pm_send = get_pixmapped_button(_(" Send "), GTK_STOCK_APPLY);
  gyachi_set_tooltip(pm_send,_(" Send "));
  g_object_set_data(G_OBJECT(pm_window), "pm_send", pm_send);
  gtk_box_pack_start (GTK_BOX (hbox5), pm_send, FALSE, FALSE, 0);
  gtk_widget_show (pm_send);

  pm_cancel = get_pixmapped_button(_(" Cancel "), GTK_STOCK_CANCEL);
  gyachi_set_tooltip(pm_cancel ,_(" Cancel "));
  g_object_set_data(G_OBJECT(pm_window), "pm_cancel", pm_cancel);
  gtk_box_pack_start (GTK_BOX (hbox5), pm_cancel, FALSE, FALSE, 0);
  gtk_widget_show (pm_cancel);

  g_signal_connect_after(G_OBJECT(pm_window), "delete-event",
                            G_CALLBACK(on_pm_window_destroy_event),
                            pm_window);
  g_signal_connect(G_OBJECT(pm_entry), "activate",
                      G_CALLBACK(on_pm_entry_activate),
                      pm_window);
  g_signal_connect(G_OBJECT(pm_send), "clicked",
                      G_CALLBACK(on_pm_send_clicked),
                      pm_window);
  g_signal_connect(G_OBJECT(pm_cancel), "clicked",
                      G_CALLBACK(on_pm_cancel_clicked),
                      pm_window);

  return pm_window;
}


/* added: PhrozenSmoke - an easier method for opening 'blank' PM windows
     or windows specifying a screen name */

GtkWidget *blank_pm_window (GtkWidget *parent, char *some_sn)
{
	GtkWidget *pm_window_widget;

	pm_window_widget = create_pm_window(parent, some_sn);
	gtk_widget_show(pm_window_widget);

	return pm_window_widget;
}
