/*****************************************************************************
 * nav.h: DVD Video Manager library, navigation functions.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: nav.h,v 1.4 2002/12/10 13:15:23 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _DVDPLAY_NAV_H
#define _DVDPLAY_NAV_H  1

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * Control structure
 *****************************************************************************/

/* Controls received from user */
typedef enum
{
    DVDCtrlLeftButtonSelect        = 0x01000001,
    DVDCtrlRightButtonSelect       = 0x01000002,
    DVDCtrlUpperButtonSelect       = 0x01000003,
    DVDCtrlLowerButtonSelect       = 0x01000004,

    DVDCtrlButtonActivate          = 0x01000005,
    DVDCtrlButtonSelect            = 0x01000006,
    DVDCtrlButtonSelectAndActivate = 0x01000007,

    DVDCtrlMouseSelect             = 0x02000001,
    DVDCtrlMouseActivate           = 0x02000002,

} dvdplay_ctrl_type_t;

typedef struct dvdplay_ctrl_button_s
{
    dvdplay_ctrl_type_t      type;

    int                     i_nr;
    
} dvdplay_ctrl_button_t;

typedef struct dvdplay_ctrl_mouse_s
{
    dvdplay_ctrl_type_t     type;

    int                     i_x;
    int                     i_y;

} dvdplay_ctrl_mouse_t;

typedef union dvdplay_ctrl_u
{
    dvdplay_ctrl_type_t      type;
    
    dvdplay_ctrl_button_t    button;
    dvdplay_ctrl_mouse_t     mouse;
} dvdplay_ctrl_t; 

typedef struct dvdplay_highlight_s
{
    int     i_x_start;
    int     i_y_start;
    int     i_x_end;
    int     i_y_end;

    uint8_t pi_color[4];
    uint8_t pi_contrast[4];
} dvdplay_highlight_t;

/*****************************************************************************
 * Exported navigation prototypes
 *****************************************************************************/
//extern int   dvdplay_cmd      ( dvdplay_ptr, vm_cmd_t * );
extern int   dvdplay_menu      ( dvdplay_ptr, dvdplay_menu_t, int );
extern int   dvdplay_resume    ( dvdplay_ptr );
extern int   dvdplay_pg        ( dvdplay_ptr, int );
extern int   dvdplay_angle     ( dvdplay_ptr, int );
extern int   dvdplay_button    ( dvdplay_ptr, dvdplay_ctrl_t* );
extern int   dvdplay_highlight ( dvdplay_ptr, dvdplay_highlight_t* );
extern int   dvdplay_next_cell ( dvdplay_ptr );
extern int   dvdplay_still_time( dvdplay_ptr );

/* dvdread wrappers */
extern int   dvdplay_nav      ( dvdplay_ptr );
extern int   dvdplay_read     ( dvdplay_ptr, byte_t*, int );
extern int   dvdplay_seek     ( dvdplay_ptr, int );


#ifdef __cplusplus
}
#endif

#endif /* <dvdplay/nav.h> */
