/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Dimension;
import javax.media.Time;
import org.bluray.media.AsynchronousPiPControl;
import org.bluray.media.PiPControl;
import org.bluray.media.PiPStatusEvent;
import org.bluray.media.PiPStatusListener;
import org.havi.ui.HScreenRectangle;
import org.videolan.BDJListeners;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.StreamInfo;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.VideoControl;

public class PiPControlImpl
extends VideoControl
implements PiPControl,
AsynchronousPiPControl {
    private BDJListeners listeners = new BDJListeners();

    protected PiPControlImpl(Handler player) {
        super(player, 1);
    }

    protected StreamInfo[] getStreams() {
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            return null;
        }
        return ci.getSecVideoStreams();
    }

    protected void setStreamNumber(int num) {
        Libbluray.writePSR(14, num << 8, 65280);
    }

    public int getCurrentStreamNumber() {
        return (Libbluray.readPSR(14) & 0xFF00) >> 8;
    }

    public void setDisplay(boolean value) {
        Libbluray.writePSR(14, value ? Integer.MIN_VALUE : 0, Integer.MIN_VALUE);
    }

    public boolean getDisplay() {
        return (Libbluray.readPSR(14) & Integer.MIN_VALUE) != 0;
    }

    public void setFullScreen(boolean value) {
        if (value) {
            this.setVideoArea(new HScreenRectangle(0.0f, 0.0f, 1.0f, 1.0f));
        } else {
            Dimension vd = this.getInputVideoSize();
            Dimension sd = this.getScreenSize();
            this.setVideoArea(new HScreenRectangle(0.5f, 0.5f, vd.width / sd.width, vd.height / sd.height));
        }
    }

    public boolean getFullScreen() {
        HScreenRectangle dr = this.getActiveVideoArea();
        return dr.x == 0.0f && dr.y == 0.0f && dr.width == 1.0f && dr.height == 1.0f;
    }

    public boolean getIsSyncedDuringTrickPlay() {
        Logger.unimplemented("PiPControlImpl", "getIsSyncedDuringTrickPlay");
        return false;
    }

    protected void onPiPStatusChange(boolean enable) {
        this.listeners.putCallback(new PiPStatusEvent(enable, this));
    }

    public void addPiPStatusListener(PiPStatusListener listener) {
        this.listeners.add(listener);
    }

    public void removePiPStatusListener(PiPStatusListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        Logger.unimplemented("PiPControlImpl", "start");
    }

    public void stop() {
        Logger.unimplemented("PiPControlImpl", "stop");
    }

    public void pause() {
        Logger.unimplemented("PiPControlImpl", "pause");
    }

    public boolean resume() {
        Logger.unimplemented("PiPControlImpl", "resume");
        return true;
    }

    public Time getElapsedTime() {
        Logger.unimplemented("PiPControlImpl", "getElapsedTime");
        return null;
    }
}

