#! /bin/sh

# Run this file after building source with Glade.
#

for file in gnome_interface.c gtk_interface.c
do
        if grep -q "DO NOT EDIT THIS FILE" $file
        then
                rm -f /tmp/$$.$file.bak
                cat > /tmp/$$.$file.bak << EOF
/* This file was created automatically by glade and fixed by fixfiles.sh */

#include <videolan/vlc.h>
EOF
                tail +8 $file \
                        | sed 's#_("/dev/dvd")#config_GetPszVariable( "dvd_device" )#' \
                        >> /tmp/$$.$file.bak
                mv -f /tmp/$$.$file.bak $file
        fi
done

file=gtk_support.h
if grep -q "DO NOT EDIT THIS FILE" $file
then
	rm -f /tmp/$$.$file.bak
	sed 's/DO NOT EDIT THIS FILE.*/This file was created automatically by glade and fixed by fixfiles.sh/ ; s/#if.*ENABLE_NLS.*/#if defined( ENABLE_NLS ) \&\& defined ( HAVE_GETTEXT )/' < $file > /tmp/$$.$file.bak
	mv -f /tmp/$$.$file.bak $file
fi

