#!/bin/sh

# Pre-Compile.sh
# MobileVLC
#
# Copyright Pierre d'Herbemont
# License is the same as the COPYING file at root of the project


pushd `dirname $0` > /dev/null
PROJECT_DIR=`pwd`
popd > /dev/null

echo "PROJECT DIR = $PROJECT_DIR"

ARCH=$ARCHS
VLC_SRC_DIR="$PROJECT_DIR/../../vlc"

if [ "$PLATFORM_NAME" = "iphoneos" ]; then
VLC_BUILD_DIR="$VLC_SRC_DIR/build-ios-OS/$CURRENT_ARCH"
VLC_INSTALL_DIR="$VLC_SRC_DIR/install-ios-OS/$CURRENT_ARCH"
else
VLC_BUILD_DIR="$VLC_SRC_DIR/build-ios-Simulator/$CURRENT_ARCH"
VLC_INSTALL_DIR="$VLC_SRC_DIR/install-ios-Simulator/$CURRENT_ARCH"
fi

VLC_CONTRIB_DIR="$VLC_INSTALL_DIR/contribs/"
LDFLAGS=""

echo "VLC_BUILD_DIR   = $VLC_BUILD_DIR"
echo "VLC_INSTALL_DIR = $VLC_INSTALL_DIR"
echo "SRC DIR         = $VLC_SRC_DIR"
echo "VLC_CONTRIB_DIR = $VLC_CONTRIB_DIR"

echo "=== Building for $ARCH ==="
echo "-"

echo "// This file is autogenerated by $(basename $0)\n\n" > $PROJECT_DIR/vlc-plugins.h
echo "// This file is autogenerated by $(basename $0)\n\n" > $PROJECT_DIR/vlc-plugins.xcconfig

VLC_MODULES=`ls $VLC_INSTALL_DIR/lib/vlc/plugins/lib*_plugin.a|tr \\\\n \ `
#echo $VLC_MODULES
BUILTINS="const void *vlc_static_modules[] = {\n"; \

LDFLAGS=""
DEFINITION=""

for file in $VLC_MODULES; do
  name=`echo $file | sed 's/.*\/lib//' | sed 's/_plugin\.a//'`
  DEFINITION+="int vlc_entry__$name (int (*)(void *, void *, int, ...), void *);\n";
  BUILTINS+=" vlc_entry__$name,\n"
  LDFLAGS+="\$(VLC_INSTALL_DIR)/lib/vlc/plugins/lib${name}_plugin.a "
  echo $name
done;

BUILTINS="$BUILTINS NULL\n};\n"

echo -e "VLC_PLUGINS_LDFLAGS=$LDFLAGS" >> $PROJECT_DIR/vlc-plugins.xcconfig
echo -e "$DEFINITION\n$BUILTINS" >> $PROJECT_DIR/vlc-plugins.h
